package software.amazon.awscdk.services.datasync;

/**
 * A CloudFormation `AWS::DataSync::Task`.
 * <p>
 * The <code>AWS::DataSync::Task</code> resource specifies a task. A task is a set of two locations (source and destination) and a set of <code>Options</code> that you use to control the behavior of a task. If you don't specify <code>Options</code> when you create a task, AWS DataSync populates them with service defaults.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnTask cfnTask = CfnTask.Builder.create(this, "MyCfnTask")
 *         .destinationLocationArn("destinationLocationArn")
 *         .sourceLocationArn("sourceLocationArn")
 *         // the properties below are optional
 *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *         .excludes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .includes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .name("name")
 *         .options(OptionsProperty.builder()
 *                 .atime("atime")
 *                 .bytesPerSecond(123)
 *                 .gid("gid")
 *                 .logLevel("logLevel")
 *                 .mtime("mtime")
 *                 .objectTags("objectTags")
 *                 .overwriteMode("overwriteMode")
 *                 .posixPermissions("posixPermissions")
 *                 .preserveDeletedFiles("preserveDeletedFiles")
 *                 .preserveDevices("preserveDevices")
 *                 .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
 *                 .taskQueueing("taskQueueing")
 *                 .transferMode("transferMode")
 *                 .uid("uid")
 *                 .verifyMode("verifyMode")
 *                 .build())
 *         .schedule(TaskScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.691Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnTask")
public class CfnTask extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnTask.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataSync::Task`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTask(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARNs of the destination elastic network interfaces (ENIs) that were created for your subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDestinationNetworkInterfaceArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDestinationNetworkInterfaceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Errors encountered during task execution.
     * <p>
     * Troubleshoot issues with this error code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrErrorCode() {
        return software.amazon.jsii.Kernel.get(this, "attrErrorCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Detailed description of an error that was encountered during the task execution.
     * <p>
     * You can use this information to help troubleshoot issues.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrErrorDetail() {
        return software.amazon.jsii.Kernel.get(this, "attrErrorDetail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARNs of the source ENIs that were created for your subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSourceNetworkInterfaceArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSourceNetworkInterfaceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The status of the task that was described.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTaskArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTaskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The key-value pair that represents the tag that you want to add to the resource.
     * <p>
     * The value can be an empty string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDestinationLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "destinationLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationLocationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationLocationArn", java.util.Objects.requireNonNull(value, "destinationLocationArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the source location for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the source location for the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceLocationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceLocationArn", java.util.Objects.requireNonNull(value, "sourceLocationArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
     * <p>
     * For more information about how to use CloudWatch Logs with DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html#cloudwatchlogs">Monitoring Your Task</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * For more information about these groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> in the <em>Amazon CloudWatch Logs User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
     * <p>
     * For more information about how to use CloudWatch Logs with DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html#cloudwatchlogs">Monitoring Your Task</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * For more information about these groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> in the <em>Amazon CloudWatch Logs User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogGroupArn", value);
    }

    /**
     * A list of filter rules that determines which files to exclude from a task.
     * <p>
     * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludes() {
        return software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of filter rules that determines which files to exclude from a task.
     * <p>
     * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludes", value);
    }

    /**
     * A list of filter rules that determines which files to exclude from a task.
     * <p>
     * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "excludes", value);
    }

    /**
     * A list of filter rules that determines which files to include when running a task.
     * <p>
     * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludes() {
        return software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of filter rules that determines which files to include when running a task.
     * <p>
     * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includes", value);
    }

    /**
     * A list of filter rules that determines which files to include when running a task.
     * <p>
     * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty, software.amazon.awscdk.core.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "includes", value);
    }

    /**
     * The name of a task.
     * <p>
     * This value is a text reference that is used to identify the task in the console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a task.
     * <p>
     * This value is a text reference that is used to identify the task in the console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
     * <p>
     * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
     * <p>
     * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
     * <p>
     * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
     * <p>
     * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
     * <p>
     * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
     * <p>
     * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     * <p>
     * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     * <p>
     * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Specifies a schedule used to periodically transfer files from a source to a destination location.
     * <p>
     * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }
    /**
     * Specifies which files, folders, and objects to include or exclude when transferring files from source to destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * FilterRuleProperty filterRuleProperty = FilterRuleProperty.builder()
     *         .filterType("filterType")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnTask.FilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of filter rule to apply.
         * <p>
         * AWS DataSync only supports the SIMPLE_PATTERN rule type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterType() {
            return null;
        }

        /**
         * A single filter string that consists of the patterns to include or exclude.
         * <p>
         * The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterRuleProperty> {
            java.lang.String filterType;
            java.lang.String value;

            /**
             * Sets the value of {@link FilterRuleProperty#getFilterType}
             * @param filterType The type of filter rule to apply.
             *                   AWS DataSync only supports the SIMPLE_PATTERN rule type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterType(java.lang.String filterType) {
                this.filterType = filterType;
                return this;
            }

            /**
             * Sets the value of {@link FilterRuleProperty#getValue}
             * @param value A single filter string that consists of the patterns to include or exclude.
             *              The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterRuleProperty {
            private final java.lang.String filterType;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterType = software.amazon.jsii.Kernel.get(this, "filterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterType = builder.filterType;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getFilterType() {
                return this.filterType;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterType() != null) {
                    data.set("filterType", om.valueToTree(this.getFilterType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_datasync.CfnTask.FilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterRuleProperty.Jsii$Proxy that = (FilterRuleProperty.Jsii$Proxy) o;

                if (this.filterType != null ? !this.filterType.equals(that.filterType) : that.filterType != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterType != null ? this.filterType.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the options that are available to control the behavior of a [StartTaskExecution](https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html) operation. This behavior includes preserving metadata, such as user ID (UID), group ID (GID), and file permissions; overwriting files in the destination; data integrity verification; and so on.
     * <p>
     * A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> , the default value is used. You can override the default options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * OptionsProperty optionsProperty = OptionsProperty.builder()
     *         .atime("atime")
     *         .bytesPerSecond(123)
     *         .gid("gid")
     *         .logLevel("logLevel")
     *         .mtime("mtime")
     *         .objectTags("objectTags")
     *         .overwriteMode("overwriteMode")
     *         .posixPermissions("posixPermissions")
     *         .preserveDeletedFiles("preserveDeletedFiles")
     *         .preserveDevices("preserveDevices")
     *         .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
     *         .taskQueueing("taskQueueing")
     *         .transferMode("transferMode")
     *         .uid("uid")
     *         .verifyMode("verifyMode")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnTask.OptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A file metadata value that shows the last time that a file was accessed (that is, when the file was read or written to).
         * <p>
         * If you set <code>Atime</code> to <code>BEST_EFFORT</code> , AWS DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code> 's behavior is not fully standard across platforms, so AWS DataSync can only do this on a best-effort basis.
         * <p>
         * Default value: <code>BEST_EFFORT</code>
         * <p>
         * <code>BEST_EFFORT</code> : Attempt to preserve the per-file <code>Atime</code> value (recommended).
         * <p>
         * <code>NONE</code> : Ignore <code>Atime</code> .
         * <p>
         * <blockquote>
         * <p>
         * If <code>Atime</code> is set to <code>BEST_EFFORT</code> , <code>Mtime</code> must be set to <code>PRESERVE</code> .
         * <p>
         * If <code>Atime</code> is set to <code>NONE</code> , <code>Mtime</code> must also be <code>NONE</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAtime() {
            return null;
        }

        /**
         * A value that limits the bandwidth used by AWS DataSync .
         * <p>
         * For example, if you want AWS DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (=1024*1024).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesPerSecond() {
            return null;
        }

        /**
         * The group ID (GID) of the file's owners.
         * <p>
         * Default value: <code>INT_VALUE</code>
         * <p>
         * <code>INT_VALUE</code> : Preserve the integer value of the user ID (UID) and group ID (GID) (recommended).
         * <p>
         * <code>NAME</code> : Currently not supported.
         * <p>
         * <code>NONE</code> : Ignore the UID and GID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGid() {
            return null;
        }

        /**
         * Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs log group.
         * <p>
         * To specify the log group, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a> .
         * <p>
         * If you set <code>LogLevel</code> to <code>OFF</code> , no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred. <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
            return null;
        }

        /**
         * A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
         * <p>
         * This option is required for cases when you need to run the same task more than one time.
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Preserve original <code>Mtime</code> (recommended)
         * <p>
         * <code>NONE</code> : Ignore <code>Mtime</code> .
         * <p>
         * <blockquote>
         * <p>
         * If <code>Mtime</code> is set to <code>PRESERVE</code> , <code>Atime</code> must be set to <code>BEST_EFFORT</code> .
         * <p>
         * If <code>Mtime</code> is set to <code>NONE</code> , <code>Atime</code> must also be set to <code>NONE</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMtime() {
            return null;
        }

        /**
         * Specifies whether object tags are preserved when transferring between object storage systems.
         * <p>
         * If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.
         * <p>
         * Default Value: <code>PRESERVE</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectTags() {
            return null;
        }

        /**
         * Specifies whether data at the destination location should be overwritten or preserved.
         * <p>
         * If set to <code>NEVER</code> , a destination file for example will not be replaced by a source file (even if the destination file differs from the source file). If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes.
         * <p>
         * Some storage classes have specific behaviors that can affect your Amazon S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverwriteMode() {
            return null;
        }

        /**
         * A value that determines which users or groups can access a file for a specific purpose, such as reading, writing, or execution of the file.
         * <p>
         * This option should be set only for Network File System (NFS), Amazon EFS, and Amazon S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a> .
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Preserve POSIX-style permissions (recommended).
         * <p>
         * <code>NONE</code> : Ignore permissions.
         * <p>
         * <blockquote>
         * <p>
         * AWS DataSync can preserve extant permissions of a source location.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPosixPermissions() {
            return null;
        }

        /**
         * A value that specifies whether files in the destination that don't exist in the source file system are preserved.
         * <p>
         * This option can affect your storage costs. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> in the <em>AWS DataSync User Guide</em> .
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Ignore destination files that aren't present in the source (recommended).
         * <p>
         * <code>REMOVE</code> : Delete destination files that aren't present in the source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreserveDeletedFiles() {
            return null;
        }

        /**
         * A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination.
         * <p>
         * DataSync does not copy the contents of such devices, only the name and metadata.
         * <p>
         * <blockquote>
         * <p>
         * AWS DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
         * <p>
         * </blockquote>
         * <p>
         * Default value: <code>NONE</code>
         * <p>
         * <code>NONE</code> : Ignore special devices (recommended).
         * <p>
         * <code>PRESERVE</code> : Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreserveDevices() {
            return null;
        }

        /**
         * A value that determines which components of the SMB security descriptor are copied from source to destination objects.
         * <p>
         * This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a> .
         * <p>
         * Default value: <code>OWNER_DACL</code>
         * <p>
         * <code>OWNER_DACL</code> : For each copied object, DataSync copies the following metadata:
         * <p>
         * <ul>
         * <li>Object owner.</li>
         * <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
         * </ul>
         * <p>
         * When you use option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
         * <p>
         * <code>OWNER_DACL_SACL</code> : For each copied object, DataSync copies the following metadata:
         * <p>
         * <ul>
         * <li>Object owner.</li>
         * <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
         * <li>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</li>
         * </ul>
         * <p>
         * Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
         * <p>
         * <code>NONE</code> : None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityDescriptorCopyFlags() {
            return null;
        }

        /**
         * Specifies whether tasks should be queued before executing the tasks.
         * <p>
         * The default is <code>ENABLED</code> , which means the tasks will be queued.
         * <p>
         * If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskQueueing() {
            return null;
        }

        /**
         * A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing it to the destination location.
         * <p>
         * <code>CHANGED</code> : DataSync copies only data or metadata that is new or different from the source location to the destination location.
         * <p>
         * <code>ALL</code> : DataSync copies all source location content to the destination, without comparing it to existing content on the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransferMode() {
            return null;
        }

        /**
         * The user ID (UID) of the file's owner.
         * <p>
         * Default value: <code>INT_VALUE</code>
         * <p>
         * <code>INT_VALUE</code> : Preserve the integer value of the UID and group ID (GID) (recommended).
         * <p>
         * <code>NAME</code> : Currently not supported
         * <p>
         * <code>NONE</code> : Ignore the UID and GID.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUid() {
            return null;
        }

        /**
         * A value that determines whether a data integrity verification is performed at the end of a task execution after all data and metadata have been transferred.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a> .
         * <p>
         * Default value: <code>POINT_IN_TIME_CONSISTENT</code>
         * <p>
         * <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification only on files that were transferred.
         * <p>
         * <code>POINT_IN_TIME_CONSISTENT</code> : Scan the entire source and entire destination at the end of the transfer to verify that the source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier or S3 Glacier Deep Archive storage classes.
         * <p>
         * <code>NONE</code> : No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVerifyMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionsProperty> {
            java.lang.String atime;
            java.lang.Number bytesPerSecond;
            java.lang.String gid;
            java.lang.String logLevel;
            java.lang.String mtime;
            java.lang.String objectTags;
            java.lang.String overwriteMode;
            java.lang.String posixPermissions;
            java.lang.String preserveDeletedFiles;
            java.lang.String preserveDevices;
            java.lang.String securityDescriptorCopyFlags;
            java.lang.String taskQueueing;
            java.lang.String transferMode;
            java.lang.String uid;
            java.lang.String verifyMode;

            /**
             * Sets the value of {@link OptionsProperty#getAtime}
             * @param atime A file metadata value that shows the last time that a file was accessed (that is, when the file was read or written to).
             *              If you set <code>Atime</code> to <code>BEST_EFFORT</code> , AWS DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code> 's behavior is not fully standard across platforms, so AWS DataSync can only do this on a best-effort basis.
             *              <p>
             *              Default value: <code>BEST_EFFORT</code>
             *              <p>
             *              <code>BEST_EFFORT</code> : Attempt to preserve the per-file <code>Atime</code> value (recommended).
             *              <p>
             *              <code>NONE</code> : Ignore <code>Atime</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              If <code>Atime</code> is set to <code>BEST_EFFORT</code> , <code>Mtime</code> must be set to <code>PRESERVE</code> .
             *              <p>
             *              If <code>Atime</code> is set to <code>NONE</code> , <code>Mtime</code> must also be <code>NONE</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder atime(java.lang.String atime) {
                this.atime = atime;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getBytesPerSecond}
             * @param bytesPerSecond A value that limits the bandwidth used by AWS DataSync .
             *                       For example, if you want AWS DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (=1024*1024).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesPerSecond(java.lang.Number bytesPerSecond) {
                this.bytesPerSecond = bytesPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getGid}
             * @param gid The group ID (GID) of the file's owners.
             *            Default value: <code>INT_VALUE</code>
             *            <p>
             *            <code>INT_VALUE</code> : Preserve the integer value of the user ID (UID) and group ID (GID) (recommended).
             *            <p>
             *            <code>NAME</code> : Currently not supported.
             *            <p>
             *            <code>NONE</code> : Ignore the UID and GID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.String gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getLogLevel}
             * @param logLevel Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs log group.
             *                 To specify the log group, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a> .
             *                 <p>
             *                 If you set <code>LogLevel</code> to <code>OFF</code> , no logs are published. <code>BASIC</code> publishes logs on errors for individual files transferred. <code>TRANSFER</code> publishes logs for every file or object that is transferred and integrity checked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getMtime}
             * @param mtime A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
             *              This option is required for cases when you need to run the same task more than one time.
             *              <p>
             *              Default value: <code>PRESERVE</code>
             *              <p>
             *              <code>PRESERVE</code> : Preserve original <code>Mtime</code> (recommended)
             *              <p>
             *              <code>NONE</code> : Ignore <code>Mtime</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              If <code>Mtime</code> is set to <code>PRESERVE</code> , <code>Atime</code> must be set to <code>BEST_EFFORT</code> .
             *              <p>
             *              If <code>Mtime</code> is set to <code>NONE</code> , <code>Atime</code> must also be set to <code>NONE</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mtime(java.lang.String mtime) {
                this.mtime = mtime;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getObjectTags}
             * @param objectTags Specifies whether object tags are preserved when transferring between object storage systems.
             *                   If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.
             *                   <p>
             *                   Default Value: <code>PRESERVE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectTags(java.lang.String objectTags) {
                this.objectTags = objectTags;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getOverwriteMode}
             * @param overwriteMode Specifies whether data at the destination location should be overwritten or preserved.
             *                      If set to <code>NEVER</code> , a destination file for example will not be replaced by a source file (even if the destination file differs from the source file). If you modify files in the destination and you sync the files, you can use this value to protect against overwriting those changes.
             *                      <p>
             *                      Some storage classes have specific behaviors that can affect your Amazon S3 storage cost. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteMode(java.lang.String overwriteMode) {
                this.overwriteMode = overwriteMode;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPosixPermissions}
             * @param posixPermissions A value that determines which users or groups can access a file for a specific purpose, such as reading, writing, or execution of the file.
             *                         This option should be set only for Network File System (NFS), Amazon EFS, and Amazon S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a> .
             *                         <p>
             *                         Default value: <code>PRESERVE</code>
             *                         <p>
             *                         <code>PRESERVE</code> : Preserve POSIX-style permissions (recommended).
             *                         <p>
             *                         <code>NONE</code> : Ignore permissions.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS DataSync can preserve extant permissions of a source location.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder posixPermissions(java.lang.String posixPermissions) {
                this.posixPermissions = posixPermissions;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPreserveDeletedFiles}
             * @param preserveDeletedFiles A value that specifies whether files in the destination that don't exist in the source file system are preserved.
             *                             This option can affect your storage costs. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> in the <em>AWS DataSync User Guide</em> .
             *                             <p>
             *                             Default value: <code>PRESERVE</code>
             *                             <p>
             *                             <code>PRESERVE</code> : Ignore destination files that aren't present in the source (recommended).
             *                             <p>
             *                             <code>REMOVE</code> : Delete destination files that aren't present in the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveDeletedFiles(java.lang.String preserveDeletedFiles) {
                this.preserveDeletedFiles = preserveDeletedFiles;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPreserveDevices}
             * @param preserveDevices A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination.
             *                        DataSync does not copy the contents of such devices, only the name and metadata.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        AWS DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
             *                        <p>
             *                        </blockquote>
             *                        <p>
             *                        Default value: <code>NONE</code>
             *                        <p>
             *                        <code>NONE</code> : Ignore special devices (recommended).
             *                        <p>
             *                        <code>PRESERVE</code> : Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveDevices(java.lang.String preserveDevices) {
                this.preserveDevices = preserveDevices;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getSecurityDescriptorCopyFlags}
             * @param securityDescriptorCopyFlags A value that determines which components of the SMB security descriptor are copied from source to destination objects.
             *                                    This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a> .
             *                                    <p>
             *                                    Default value: <code>OWNER_DACL</code>
             *                                    <p>
             *                                    <code>OWNER_DACL</code> : For each copied object, DataSync copies the following metadata:
             *                                    <p>
             *                                    <ul>
             *                                    <li>Object owner.</li>
             *                                    <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
             *                                    </ul>
             *                                    <p>
             *                                    When you use option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
             *                                    <p>
             *                                    <code>OWNER_DACL_SACL</code> : For each copied object, DataSync copies the following metadata:
             *                                    <p>
             *                                    <ul>
             *                                    <li>Object owner.</li>
             *                                    <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
             *                                    <li>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</li>
             *                                    </ul>
             *                                    <p>
             *                                    Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
             *                                    <p>
             *                                    <code>NONE</code> : None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityDescriptorCopyFlags(java.lang.String securityDescriptorCopyFlags) {
                this.securityDescriptorCopyFlags = securityDescriptorCopyFlags;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getTaskQueueing}
             * @param taskQueueing Specifies whether tasks should be queued before executing the tasks.
             *                     The default is <code>ENABLED</code> , which means the tasks will be queued.
             *                     <p>
             *                     If you use the same agent to run multiple tasks, you can enable the tasks to run in series. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#queue-task-execution">Queueing task executions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskQueueing(java.lang.String taskQueueing) {
                this.taskQueueing = taskQueueing;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getTransferMode}
             * @param transferMode A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing it to the destination location.
             *                     <code>CHANGED</code> : DataSync copies only data or metadata that is new or different from the source location to the destination location.
             *                     <p>
             *                     <code>ALL</code> : DataSync copies all source location content to the destination, without comparing it to existing content on the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transferMode(java.lang.String transferMode) {
                this.transferMode = transferMode;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getUid}
             * @param uid The user ID (UID) of the file's owner.
             *            Default value: <code>INT_VALUE</code>
             *            <p>
             *            <code>INT_VALUE</code> : Preserve the integer value of the UID and group ID (GID) (recommended).
             *            <p>
             *            <code>NAME</code> : Currently not supported
             *            <p>
             *            <code>NONE</code> : Ignore the UID and GID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.String uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getVerifyMode}
             * @param verifyMode A value that determines whether a data integrity verification is performed at the end of a task execution after all data and metadata have been transferred.
             *                   For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a> .
             *                   <p>
             *                   Default value: <code>POINT_IN_TIME_CONSISTENT</code>
             *                   <p>
             *                   <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification only on files that were transferred.
             *                   <p>
             *                   <code>POINT_IN_TIME_CONSISTENT</code> : Scan the entire source and entire destination at the end of the transfer to verify that the source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier or S3 Glacier Deep Archive storage classes.
             *                   <p>
             *                   <code>NONE</code> : No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verifyMode(java.lang.String verifyMode) {
                this.verifyMode = verifyMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionsProperty {
            private final java.lang.String atime;
            private final java.lang.Number bytesPerSecond;
            private final java.lang.String gid;
            private final java.lang.String logLevel;
            private final java.lang.String mtime;
            private final java.lang.String objectTags;
            private final java.lang.String overwriteMode;
            private final java.lang.String posixPermissions;
            private final java.lang.String preserveDeletedFiles;
            private final java.lang.String preserveDevices;
            private final java.lang.String securityDescriptorCopyFlags;
            private final java.lang.String taskQueueing;
            private final java.lang.String transferMode;
            private final java.lang.String uid;
            private final java.lang.String verifyMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.atime = software.amazon.jsii.Kernel.get(this, "atime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesPerSecond = software.amazon.jsii.Kernel.get(this, "bytesPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mtime = software.amazon.jsii.Kernel.get(this, "mtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectTags = software.amazon.jsii.Kernel.get(this, "objectTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteMode = software.amazon.jsii.Kernel.get(this, "overwriteMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.posixPermissions = software.amazon.jsii.Kernel.get(this, "posixPermissions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preserveDeletedFiles = software.amazon.jsii.Kernel.get(this, "preserveDeletedFiles", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preserveDevices = software.amazon.jsii.Kernel.get(this, "preserveDevices", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityDescriptorCopyFlags = software.amazon.jsii.Kernel.get(this, "securityDescriptorCopyFlags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskQueueing = software.amazon.jsii.Kernel.get(this, "taskQueueing", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transferMode = software.amazon.jsii.Kernel.get(this, "transferMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.verifyMode = software.amazon.jsii.Kernel.get(this, "verifyMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.atime = builder.atime;
                this.bytesPerSecond = builder.bytesPerSecond;
                this.gid = builder.gid;
                this.logLevel = builder.logLevel;
                this.mtime = builder.mtime;
                this.objectTags = builder.objectTags;
                this.overwriteMode = builder.overwriteMode;
                this.posixPermissions = builder.posixPermissions;
                this.preserveDeletedFiles = builder.preserveDeletedFiles;
                this.preserveDevices = builder.preserveDevices;
                this.securityDescriptorCopyFlags = builder.securityDescriptorCopyFlags;
                this.taskQueueing = builder.taskQueueing;
                this.transferMode = builder.transferMode;
                this.uid = builder.uid;
                this.verifyMode = builder.verifyMode;
            }

            @Override
            public final java.lang.String getAtime() {
                return this.atime;
            }

            @Override
            public final java.lang.Number getBytesPerSecond() {
                return this.bytesPerSecond;
            }

            @Override
            public final java.lang.String getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            public final java.lang.String getMtime() {
                return this.mtime;
            }

            @Override
            public final java.lang.String getObjectTags() {
                return this.objectTags;
            }

            @Override
            public final java.lang.String getOverwriteMode() {
                return this.overwriteMode;
            }

            @Override
            public final java.lang.String getPosixPermissions() {
                return this.posixPermissions;
            }

            @Override
            public final java.lang.String getPreserveDeletedFiles() {
                return this.preserveDeletedFiles;
            }

            @Override
            public final java.lang.String getPreserveDevices() {
                return this.preserveDevices;
            }

            @Override
            public final java.lang.String getSecurityDescriptorCopyFlags() {
                return this.securityDescriptorCopyFlags;
            }

            @Override
            public final java.lang.String getTaskQueueing() {
                return this.taskQueueing;
            }

            @Override
            public final java.lang.String getTransferMode() {
                return this.transferMode;
            }

            @Override
            public final java.lang.String getUid() {
                return this.uid;
            }

            @Override
            public final java.lang.String getVerifyMode() {
                return this.verifyMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAtime() != null) {
                    data.set("atime", om.valueToTree(this.getAtime()));
                }
                if (this.getBytesPerSecond() != null) {
                    data.set("bytesPerSecond", om.valueToTree(this.getBytesPerSecond()));
                }
                if (this.getGid() != null) {
                    data.set("gid", om.valueToTree(this.getGid()));
                }
                if (this.getLogLevel() != null) {
                    data.set("logLevel", om.valueToTree(this.getLogLevel()));
                }
                if (this.getMtime() != null) {
                    data.set("mtime", om.valueToTree(this.getMtime()));
                }
                if (this.getObjectTags() != null) {
                    data.set("objectTags", om.valueToTree(this.getObjectTags()));
                }
                if (this.getOverwriteMode() != null) {
                    data.set("overwriteMode", om.valueToTree(this.getOverwriteMode()));
                }
                if (this.getPosixPermissions() != null) {
                    data.set("posixPermissions", om.valueToTree(this.getPosixPermissions()));
                }
                if (this.getPreserveDeletedFiles() != null) {
                    data.set("preserveDeletedFiles", om.valueToTree(this.getPreserveDeletedFiles()));
                }
                if (this.getPreserveDevices() != null) {
                    data.set("preserveDevices", om.valueToTree(this.getPreserveDevices()));
                }
                if (this.getSecurityDescriptorCopyFlags() != null) {
                    data.set("securityDescriptorCopyFlags", om.valueToTree(this.getSecurityDescriptorCopyFlags()));
                }
                if (this.getTaskQueueing() != null) {
                    data.set("taskQueueing", om.valueToTree(this.getTaskQueueing()));
                }
                if (this.getTransferMode() != null) {
                    data.set("transferMode", om.valueToTree(this.getTransferMode()));
                }
                if (this.getUid() != null) {
                    data.set("uid", om.valueToTree(this.getUid()));
                }
                if (this.getVerifyMode() != null) {
                    data.set("verifyMode", om.valueToTree(this.getVerifyMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_datasync.CfnTask.OptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionsProperty.Jsii$Proxy that = (OptionsProperty.Jsii$Proxy) o;

                if (this.atime != null ? !this.atime.equals(that.atime) : that.atime != null) return false;
                if (this.bytesPerSecond != null ? !this.bytesPerSecond.equals(that.bytesPerSecond) : that.bytesPerSecond != null) return false;
                if (this.gid != null ? !this.gid.equals(that.gid) : that.gid != null) return false;
                if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
                if (this.mtime != null ? !this.mtime.equals(that.mtime) : that.mtime != null) return false;
                if (this.objectTags != null ? !this.objectTags.equals(that.objectTags) : that.objectTags != null) return false;
                if (this.overwriteMode != null ? !this.overwriteMode.equals(that.overwriteMode) : that.overwriteMode != null) return false;
                if (this.posixPermissions != null ? !this.posixPermissions.equals(that.posixPermissions) : that.posixPermissions != null) return false;
                if (this.preserveDeletedFiles != null ? !this.preserveDeletedFiles.equals(that.preserveDeletedFiles) : that.preserveDeletedFiles != null) return false;
                if (this.preserveDevices != null ? !this.preserveDevices.equals(that.preserveDevices) : that.preserveDevices != null) return false;
                if (this.securityDescriptorCopyFlags != null ? !this.securityDescriptorCopyFlags.equals(that.securityDescriptorCopyFlags) : that.securityDescriptorCopyFlags != null) return false;
                if (this.taskQueueing != null ? !this.taskQueueing.equals(that.taskQueueing) : that.taskQueueing != null) return false;
                if (this.transferMode != null ? !this.transferMode.equals(that.transferMode) : that.transferMode != null) return false;
                if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) return false;
                return this.verifyMode != null ? this.verifyMode.equals(that.verifyMode) : that.verifyMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.atime != null ? this.atime.hashCode() : 0;
                result = 31 * result + (this.bytesPerSecond != null ? this.bytesPerSecond.hashCode() : 0);
                result = 31 * result + (this.gid != null ? this.gid.hashCode() : 0);
                result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
                result = 31 * result + (this.mtime != null ? this.mtime.hashCode() : 0);
                result = 31 * result + (this.objectTags != null ? this.objectTags.hashCode() : 0);
                result = 31 * result + (this.overwriteMode != null ? this.overwriteMode.hashCode() : 0);
                result = 31 * result + (this.posixPermissions != null ? this.posixPermissions.hashCode() : 0);
                result = 31 * result + (this.preserveDeletedFiles != null ? this.preserveDeletedFiles.hashCode() : 0);
                result = 31 * result + (this.preserveDevices != null ? this.preserveDevices.hashCode() : 0);
                result = 31 * result + (this.securityDescriptorCopyFlags != null ? this.securityDescriptorCopyFlags.hashCode() : 0);
                result = 31 * result + (this.taskQueueing != null ? this.taskQueueing.hashCode() : 0);
                result = 31 * result + (this.transferMode != null ? this.transferMode.hashCode() : 0);
                result = 31 * result + (this.uid != null ? this.uid.hashCode() : 0);
                result = 31 * result + (this.verifyMode != null ? this.verifyMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the schedule you want your task to use for repeated executions.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expressions for Rules</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * TaskScheduleProperty taskScheduleProperty = TaskScheduleProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_datasync.CfnTask.TaskScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * @return a {@link Builder} of {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskScheduleProperty> {
            java.lang.String scheduleExpression;

            /**
             * Sets the value of {@link TaskScheduleProperty#getScheduleExpression}
             * @param scheduleExpression A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskScheduleProperty {
            private final java.lang.String scheduleExpression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_datasync.CfnTask.TaskScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskScheduleProperty.Jsii$Proxy that = (TaskScheduleProperty.Jsii$Proxy) o;

                return this.scheduleExpression.equals(that.scheduleExpression);
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datasync.CfnTaskProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datasync.CfnTaskProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of an AWS storage resource's location.
         * <p>
         * @return {@code this}
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(final java.lang.String destinationLocationArn) {
            this.props.destinationLocationArn(destinationLocationArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the source location for the task.
         * <p>
         * @return {@code this}
         * @param sourceLocationArn The Amazon Resource Name (ARN) of the source location for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(final java.lang.String sourceLocationArn) {
            this.props.sourceLocationArn(sourceLocationArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task.
         * <p>
         * For more information about how to use CloudWatch Logs with DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/monitor-datasync.html#cloudwatchlogs">Monitoring Your Task</a> in the <em>AWS DataSync User Guide.</em>
         * <p>
         * For more information about these groups, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working with Log Groups and Log Streams</a> in the <em>Amazon CloudWatch Logs User Guide</em> .
         * <p>
         * @return {@code this}
         * @param cloudWatchLogGroupArn The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used to monitor and log events in the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(final java.lang.String cloudWatchLogGroupArn) {
            this.props.cloudWatchLogGroupArn(cloudWatchLogGroupArn);
            return this;
        }

        /**
         * A list of filter rules that determines which files to exclude from a task.
         * <p>
         * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * <p>
         * @return {@code this}
         * @param excludes A list of filter rules that determines which files to exclude from a task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(final software.amazon.awscdk.core.IResolvable excludes) {
            this.props.excludes(excludes);
            return this;
        }
        /**
         * A list of filter rules that determines which files to exclude from a task.
         * <p>
         * The list should contain a single filter string that consists of the patterns to exclude. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * <p>
         * @return {@code this}
         * @param excludes A list of filter rules that determines which files to exclude from a task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(final java.util.List<? extends java.lang.Object> excludes) {
            this.props.excludes(excludes);
            return this;
        }

        /**
         * A list of filter rules that determines which files to include when running a task.
         * <p>
         * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * <p>
         * @return {@code this}
         * @param includes A list of filter rules that determines which files to include when running a task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(final software.amazon.awscdk.core.IResolvable includes) {
            this.props.includes(includes);
            return this;
        }
        /**
         * A list of filter rules that determines which files to include when running a task.
         * <p>
         * The pattern contains a single filter string that consists of the patterns to include. The patterns are delimited by "|" (that is, a pipe), for example, <code>"/folder1|/folder2"</code> .
         * <p>
         * @return {@code this}
         * @param includes A list of filter rules that determines which files to include when running a task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(final java.util.List<? extends java.lang.Object> includes) {
            this.props.includes(includes);
            return this;
        }

        /**
         * The name of a task.
         * <p>
         * This value is a text reference that is used to identify the task in the console.
         * <p>
         * @return {@code this}
         * @param name The name of a task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
         * <p>
         * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
         * <p>
         * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
         * <p>
         * @return {@code this}
         * @param options The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty options) {
            this.props.options(options);
            return this;
        }
        /**
         * The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` .
         * <p>
         * You can configure these options to preserve metadata such as user ID (UID) and group ID (GID), file permissions, data integrity verification, and so on.
         * <p>
         * For each individual task execution, you can override these options by specifying the <code>OverrideOptions</code> before starting the task execution. For more information, see the <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation.
         * <p>
         * @return {@code this}
         * @param options The set of configuration options that control the behavior of a single execution of the task that occurs when you call `StartTaskExecution` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.core.IResolvable options) {
            this.props.options(options);
            return this;
        }

        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location.
         * <p>
         * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * <p>
         * @return {@code this}
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * Specifies a schedule used to periodically transfer files from a source to a destination location.
         * <p>
         * The schedule should be specified in UTC time. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * <p>
         * @return {@code this}
         * @param schedule Specifies a schedule used to periodically transfer files from a source to a destination location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.core.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The key-value pair that represents the tag that you want to add to the resource.
         * <p>
         * The value can be an empty string.
         * <p>
         * @return {@code this}
         * @param tags The key-value pair that represents the tag that you want to add to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnTask build() {
            return new software.amazon.awscdk.services.datasync.CfnTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
