package software.amazon.awscdk.services.docdb;

/**
 * (experimental) A database secret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DatabaseCluster cluster;
 * DatabaseSecret myUserSecret = DatabaseSecret.Builder.create(this, "MyUserSecret")
 *         .username("myuser")
 *         .masterSecret(cluster.getSecret())
 *         .build();
 * ISecret myUserSecretAttached = myUserSecret.attach(cluster); // Adds DB connections information in the secret
 * cluster.addRotationMultiUser("MyUser", RotationMultiUserOptions.builder() // Add rotation using the multi user scheme
 *         .secret(myUserSecretAttached).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:57.982Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_docdb.DatabaseSecret")
public class DatabaseSecret extends software.amazon.awscdk.services.secretsmanager.Secret {

    protected DatabaseSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DatabaseSecret(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.DatabaseSecretProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.docdb.DatabaseSecret}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.docdb.DatabaseSecret> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.docdb.DatabaseSecretProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.docdb.DatabaseSecretProps.Builder();
        }

        /**
         * (experimental) The username.
         * <p>
         * @return {@code this}
         * @param username The username. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder username(final java.lang.String username) {
            this.props.username(username);
            return this;
        }

        /**
         * (experimental) The KMS key to use to encrypt the secret.
         * <p>
         * Default: default master key
         * <p>
         * @return {@code this}
         * @param encryptionKey The KMS key to use to encrypt the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * (experimental) Characters to not include in the generated password.
         * <p>
         * Default: "\"
         * <p>
         * @return {@code this}
         * @param excludeCharacters Characters to not include in the generated password. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder excludeCharacters(final java.lang.String excludeCharacters) {
            this.props.excludeCharacters(excludeCharacters);
            return this;
        }

        /**
         * (experimental) The master secret which will be used to rotate this secret.
         * <p>
         * Default: - no master secret information will be included
         * <p>
         * @return {@code this}
         * @param masterSecret The master secret which will be used to rotate this secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder masterSecret(final software.amazon.awscdk.services.secretsmanager.ISecret masterSecret) {
            this.props.masterSecret(masterSecret);
            return this;
        }

        /**
         * (experimental) The physical name of the secret.
         * <p>
         * Default: Secretsmanager will generate a physical name for the secret
         * <p>
         * @return {@code this}
         * @param secretName The physical name of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretName(final java.lang.String secretName) {
            this.props.secretName(secretName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.docdb.DatabaseSecret}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.docdb.DatabaseSecret build() {
            return new software.amazon.awscdk.services.docdb.DatabaseSecret(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
