package software.amazon.awscdk.services.dynamodb;

/**
 * (experimental) What kind of server-side encryption to apply to this table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "MyTable")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .encryption(TableEncryption.CUSTOMER_MANAGED)
 *         .build();
 * // You can access the CMK that was added to the stack on your behalf by the Table construct via:
 * IKey tableEncryptionKey = table.getEncryptionKey();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:58.128Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_dynamodb.TableEncryption")
public enum TableEncryption {
    /**
     * (experimental) Server-side KMS encryption with a master key owned by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DEFAULT,
    /**
     * (experimental) Server-side KMS encryption with a customer master key managed by customer.
     * <p>
     * If <code>encryptionKey</code> is specified, this key will be used, otherwise, one will be defined.
     * <p>
     * <blockquote>
     * <p>
     * <strong>NOTE</strong>: if <code>encryptionKey</code> is not specified and the <code>Table</code> construct creates
     * a KMS key for you, the key will be created with default permissions. If you are using
     * CDKv2, these permissions will be sufficient to enable the key for use with DynamoDB tables.
     * If you are using CDKv1, make sure the feature flag <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code>
     * is set to <code>true</code> in your <code>cdk.json</code>.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CUSTOMER_MANAGED,
    /**
     * (experimental) Server-side KMS encryption with a master key managed by AWS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    AWS_MANAGED,
}
