package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Amazon Linux Kernel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * // AWS Linux
 * // AWS Linux
 * Instance.Builder.create(this, "Instance1")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(new AmazonLinuxImage())
 *         .build();
 * // AWS Linux 2
 * // AWS Linux 2
 * Instance.Builder.create(this, "Instance2")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .build();
 * // AWS Linux 2 with kernel 5.x
 * // AWS Linux 2 with kernel 5.x
 * Instance.Builder.create(this, "Instance3")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .kernel(AmazonLinuxKernel.KERNEL5_X)
 *                 .build())
 *         .build();
 * // AWS Linux 2022
 * // AWS Linux 2022
 * Instance.Builder.create(this, "Instance4")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2022)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:58.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.AmazonLinuxKernel")
public enum AmazonLinuxKernel {
    /**
     * (experimental) Standard edition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KERNEL5_X,
}
