package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Construct a Linux machine image from an AMI map.
 * <p>
 * Linux images IDs are not published to SSM parameter store yet, so you'll have to
 * manually specify an AMI map.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Pick a Windows edition to use
 * WindowsImage windows = new WindowsImage(WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
 * // Pick the right Amazon Linux edition. All arguments shown are optional
 * // and will default to these values when omitted.
 * AmazonLinuxImage amznLinux = AmazonLinuxImage.Builder.create()
 *         .generation(AmazonLinuxGeneration.AMAZON_LINUX)
 *         .edition(AmazonLinuxEdition.STANDARD)
 *         .virtualization(AmazonLinuxVirt.HVM)
 *         .storage(AmazonLinuxStorage.GENERAL_PURPOSE)
 *         .build();
 * // For other custom (Linux) images, instantiate a `GenericLinuxImage` with
 * // a map giving the AMI to in for each region:
 * GenericLinuxImage linux = new GenericLinuxImage(Map.of(
 *         "us-east-1", "ami-97785bed",
 *         "eu-west-1", "ami-12345678"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.038Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.GenericLinuxImage")
public class GenericLinuxImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected GenericLinuxImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericLinuxImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param amiMap This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GenericLinuxImage(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.GenericLinuxImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required"), props });
    }

    /**
     * @param amiMap This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public GenericLinuxImage(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> amiMap) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(amiMap, "amiMap is required") });
    }

    /**
     * (experimental) Return the image to use in the given context.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.GenericLinuxImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.GenericLinuxImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param amiMap This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            return new Builder(amiMap);
        }

        private final java.util.Map<java.lang.String, java.lang.String> amiMap;
        private software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder props;

        private Builder(final java.util.Map<java.lang.String, java.lang.String> amiMap) {
            this.amiMap = amiMap;
        }

        /**
         * (experimental) Initial user data.
         * <p>
         * Default: - Empty UserData for Linux machines
         * <p>
         * @return {@code this}
         * @param userData Initial user data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userData(final software.amazon.awscdk.services.ec2.UserData userData) {
            this.props().userData(userData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.GenericLinuxImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.GenericLinuxImage build() {
            return new software.amazon.awscdk.services.ec2.GenericLinuxImage(
                this.amiMap,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.GenericLinuxImageProps.Builder();
            }
            return this.props;
        }
    }
}
