package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Interface for classes that provide the connection-specification parts of a security group rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer loadBalancer;
 * Vpc vpc = new Vpc(this, "MyVPC");
 * Project project = Project.Builder.create(this, "MyProject")
 *         .vpc(vpc)
 *         .buildSpec(BuildSpec.fromObject(Map.of()))
 *         .build();
 * project.connections.allowTo(loadBalancer, Port.tcp(443));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.Port")
public class Port extends software.amazon.jsii.JsiiObject {

    protected Port(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Port(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Port(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PortProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) A single AH port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port ah() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "ah", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) All ICMP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allIcmp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allIcmp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) Any TCP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allTcp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) All traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allTraffic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) Any UDP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allUdp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allUdp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) A single ESP port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port esp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "esp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) ICMP ping (echo) traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpPing() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpPing", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * (experimental) All codes for a single ICMP type.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpType(final @org.jetbrains.annotations.NotNull java.lang.Number type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) A specific combination of ICMP type and code.
     * <p>
     * @see <a href="https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml">https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml</a>
     * @param type This parameter is required.
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpTypeAndCode(final @org.jetbrains.annotations.NotNull java.lang.Number type, final @org.jetbrains.annotations.NotNull java.lang.Number code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpTypeAndCode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * (experimental) A single TCP port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port tcp(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * (experimental) A TCP port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port tcpRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcpRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * (experimental) A single UDP port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port udp(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * (experimental) A UDP port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port udpRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udpRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * (experimental) Produce the ingress/egress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Object toRuleJson() {
        return software.amazon.jsii.Kernel.call(this, "toRuleJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Whether the rule containing this port range can be inlined into a securitygroup or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
        return software.amazon.jsii.Kernel.get(this, "canInlineRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ec2.Port}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Port> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.PortProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.PortProps.Builder();
        }

        /**
         * (experimental) The protocol for the range.
         * <p>
         * @return {@code this}
         * @param protocol The protocol for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(final software.amazon.awscdk.services.ec2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * (experimental) String representation for this object.
         * <p>
         * @return {@code this}
         * @param stringRepresentation String representation for this object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stringRepresentation(final java.lang.String stringRepresentation) {
            this.props.stringRepresentation(stringRepresentation);
            return this;
        }

        /**
         * (experimental) The starting port for the range.
         * <p>
         * Default: - Not included in the rule
         * <p>
         * @return {@code this}
         * @param fromPort The starting port for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fromPort(final java.lang.Number fromPort) {
            this.props.fromPort(fromPort);
            return this;
        }

        /**
         * (experimental) The ending port for the range.
         * <p>
         * Default: - Not included in the rule
         * <p>
         * @return {@code this}
         * @param toPort The ending port for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder toPort(final java.lang.Number toPort) {
            this.props.toPort(toPort);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ec2.Port}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ec2.Port build() {
            return new software.amazon.awscdk.services.ec2.Port(
                this.props.build()
            );
        }
    }
}
