package software.amazon.awscdk.services.ec2;

/**
 * (experimental) Attributes of an imported VpnConnection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * VpnConnectionAttributes vpnConnectionAttributes = VpnConnectionAttributes.builder()
 *         .customerGatewayAsn(123)
 *         .customerGatewayId("customerGatewayId")
 *         .customerGatewayIp("customerGatewayIp")
 *         .vpnId("vpnId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.281Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ec2.VpnConnectionAttributes")
@software.amazon.jsii.Jsii.Proxy(VpnConnectionAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface VpnConnectionAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The ASN of the customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getCustomerGatewayAsn();

    /**
     * (experimental) The id of the customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId();

    /**
     * (experimental) The ip address of the customer gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayIp();

    /**
     * (experimental) The id of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getVpnId();

    /**
     * @return a {@link Builder} of {@link VpnConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpnConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<VpnConnectionAttributes> {
        java.lang.Number customerGatewayAsn;
        java.lang.String customerGatewayId;
        java.lang.String customerGatewayIp;
        java.lang.String vpnId;

        /**
         * Sets the value of {@link VpnConnectionAttributes#getCustomerGatewayAsn}
         * @param customerGatewayAsn The ASN of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customerGatewayAsn(java.lang.Number customerGatewayAsn) {
            this.customerGatewayAsn = customerGatewayAsn;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionAttributes#getCustomerGatewayId}
         * @param customerGatewayId The id of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customerGatewayId(java.lang.String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionAttributes#getCustomerGatewayIp}
         * @param customerGatewayIp The ip address of the customer gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customerGatewayIp(java.lang.String customerGatewayIp) {
            this.customerGatewayIp = customerGatewayIp;
            return this;
        }

        /**
         * Sets the value of {@link VpnConnectionAttributes#getVpnId}
         * @param vpnId The id of the VPN connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpnId(java.lang.String vpnId) {
            this.vpnId = vpnId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpnConnectionAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public VpnConnectionAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpnConnectionAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnConnectionAttributes {
        private final java.lang.Number customerGatewayAsn;
        private final java.lang.String customerGatewayId;
        private final java.lang.String customerGatewayIp;
        private final java.lang.String vpnId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.customerGatewayAsn = software.amazon.jsii.Kernel.get(this, "customerGatewayAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customerGatewayId = software.amazon.jsii.Kernel.get(this, "customerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerGatewayIp = software.amazon.jsii.Kernel.get(this, "customerGatewayIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnId = software.amazon.jsii.Kernel.get(this, "vpnId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.customerGatewayAsn = java.util.Objects.requireNonNull(builder.customerGatewayAsn, "customerGatewayAsn is required");
            this.customerGatewayId = java.util.Objects.requireNonNull(builder.customerGatewayId, "customerGatewayId is required");
            this.customerGatewayIp = java.util.Objects.requireNonNull(builder.customerGatewayIp, "customerGatewayIp is required");
            this.vpnId = java.util.Objects.requireNonNull(builder.vpnId, "vpnId is required");
        }

        @Override
        public final java.lang.Number getCustomerGatewayAsn() {
            return this.customerGatewayAsn;
        }

        @Override
        public final java.lang.String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final java.lang.String getCustomerGatewayIp() {
            return this.customerGatewayIp;
        }

        @Override
        public final java.lang.String getVpnId() {
            return this.vpnId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("customerGatewayAsn", om.valueToTree(this.getCustomerGatewayAsn()));
            data.set("customerGatewayId", om.valueToTree(this.getCustomerGatewayId()));
            data.set("customerGatewayIp", om.valueToTree(this.getCustomerGatewayIp()));
            data.set("vpnId", om.valueToTree(this.getVpnId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ec2.VpnConnectionAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpnConnectionAttributes.Jsii$Proxy that = (VpnConnectionAttributes.Jsii$Proxy) o;

            if (!customerGatewayAsn.equals(that.customerGatewayAsn)) return false;
            if (!customerGatewayId.equals(that.customerGatewayId)) return false;
            if (!customerGatewayIp.equals(that.customerGatewayIp)) return false;
            return this.vpnId.equals(that.vpnId);
        }

        @Override
        public final int hashCode() {
            int result = this.customerGatewayAsn.hashCode();
            result = 31 * result + (this.customerGatewayId.hashCode());
            result = 31 * result + (this.customerGatewayIp.hashCode());
            result = 31 * result + (this.vpnId.hashCode());
            return result;
        }
    }
}
