package software.amazon.awscdk.services.ecr.assets;

/**
 * (experimental) platform supported by docker.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * import software.amazon.awscdk.services.ecr.assets.Platform;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .platform(Platform.LINUX_ARM64)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.374Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecr_assets.Platform")
public class Platform extends software.amazon.jsii.JsiiObject {

    protected Platform(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Platform(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        LINUX_AMD64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.Platform.class, "LINUX_AMD64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
        LINUX_ARM64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecr.assets.Platform.class, "LINUX_ARM64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
    }

    /**
     * (experimental) Used to specify a custom platform Use this if the platform name is not yet supported by the CDK.
     * <p>
     * @param platform The platform to use for docker build. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.Platform custom(final @org.jetbrains.annotations.NotNull java.lang.String platform) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.assets.Platform.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class), new Object[] { java.util.Objects.requireNonNull(platform, "platform is required") });
    }

    /**
     * (experimental) Build for linux/amd64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.ecr.assets.Platform LINUX_AMD64;

    /**
     * (experimental) Build for linux/arm64.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.ecr.assets.Platform LINUX_ARM64;

    /**
     * (experimental) The platform to use for docker build.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPlatform() {
        return software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
