package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The properties for building an AssetImage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.assets.*;
 * import software.amazon.awscdk.services.ecr.assets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * NetworkMode networkMode;
 * Platform platform;
 * AssetImageProps assetImageProps = AssetImageProps.builder()
 *         .buildArgs(Map.of(
 *                 "buildArgsKey", "buildArgs"))
 *         .exclude(List.of("exclude"))
 *         .extraHash("extraHash")
 *         .file("file")
 *         .follow(FollowMode.NEVER)
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .invalidation(DockerImageAssetInvalidationOptions.builder()
 *                 .buildArgs(false)
 *                 .extraHash(false)
 *                 .file(false)
 *                 .networkMode(false)
 *                 .platform(false)
 *                 .repositoryName(false)
 *                 .target(false)
 *                 .build())
 *         .networkMode(networkMode)
 *         .platform(platform)
 *         .repositoryName("repositoryName")
 *         .target("target")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.474Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.AssetImageProps")
@software.amazon.jsii.Jsii.Proxy(AssetImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AssetImageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecr.assets.DockerImageAssetOptions {

    /**
     * @return a {@link Builder} of {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AssetImageProps> {
        java.util.Map<java.lang.String, java.lang.String> buildArgs;
        java.lang.String file;
        software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation;
        software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode;
        software.amazon.awscdk.services.ecr.assets.Platform platform;
        java.lang.String repositoryName;
        java.lang.String target;
        java.lang.String extraHash;
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.assets.FollowMode follow;
        software.amazon.awscdk.core.IgnoreMode ignoreMode;
        software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;

        /**
         * Sets the value of {@link AssetImageProps#getBuildArgs}
         * @param buildArgs Build args to pass to the `docker build` command.
         *                  Since Docker build arguments are resolved before deployment, keys and
         *                  values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         *                  <code>queue.queueUrl</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder buildArgs(java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getFile}
         * @param file Path to the Dockerfile (relative to the directory).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder file(java.lang.String file) {
            this.file = file;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getInvalidation}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder invalidation(software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.invalidation = invalidation;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getNetworkMode}
         * @param networkMode Networking mode for the RUN commands during build.
         *                    Support docker API 1.25+.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder networkMode(software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getPlatform}
         * @param platform Platform to build for.
         *                 <em>Requires Docker Buildx</em>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platform(software.amazon.awscdk.services.ecr.assets.Platform platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getRepositoryName}
         * @param repositoryName ECR repository name.
         *                       Specify this property if you need to statically address the image, e.g.
         *                       from a Kubernetes Pod. Note, this is only the repository name, without the
         *                       registry and the tag parts.
         * @return {@code this}
         * @deprecated to control the location of docker image assets, please override
`Stack.addDockerImageAsset`. this feature will be removed in future
releases.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getTarget}
         * @param target Docker target to build to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getExtraHash}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraHash(java.lang.String extraHash) {
            this.extraHash = extraHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getExclude}
         * @param exclude Glob patterns to exclude from the copy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getFollow}
         * @param follow A strategy for how to handle symlinks.
         * @return {@code this}
         * @deprecated use `followSymlinks` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder follow(software.amazon.awscdk.assets.FollowMode follow) {
            this.follow = follow;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for exclude patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ignoreMode(software.amazon.awscdk.core.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Sets the value of {@link AssetImageProps#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder followSymlinks(software.amazon.awscdk.core.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AssetImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetImageProps {
        private final java.util.Map<java.lang.String, java.lang.String> buildArgs;
        private final java.lang.String file;
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation;
        private final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode;
        private final software.amazon.awscdk.services.ecr.assets.Platform platform;
        private final java.lang.String repositoryName;
        private final java.lang.String target;
        private final java.lang.String extraHash;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.assets.FollowMode follow;
        private final software.amazon.awscdk.core.IgnoreMode ignoreMode;
        private final software.amazon.awscdk.core.SymlinkFollowMode followSymlinks;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildArgs = software.amazon.jsii.Kernel.get(this, "buildArgs", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.invalidation = software.amazon.jsii.Kernel.get(this, "invalidation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.NetworkMode.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.assets.Platform.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraHash = software.amazon.jsii.Kernel.get(this, "extraHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.follow = software.amazon.jsii.Kernel.get(this, "follow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.assets.FollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IgnoreMode.class));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.SymlinkFollowMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildArgs = builder.buildArgs;
            this.file = builder.file;
            this.invalidation = builder.invalidation;
            this.networkMode = builder.networkMode;
            this.platform = builder.platform;
            this.repositoryName = builder.repositoryName;
            this.target = builder.target;
            this.extraHash = builder.extraHash;
            this.exclude = builder.exclude;
            this.follow = builder.follow;
            this.ignoreMode = builder.ignoreMode;
            this.followSymlinks = builder.followSymlinks;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBuildArgs() {
            return this.buildArgs;
        }

        @Override
        public final java.lang.String getFile() {
            return this.file;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions getInvalidation() {
            return this.invalidation;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.assets.Platform getPlatform() {
            return this.platform;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.String getExtraHash() {
            return this.extraHash;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.assets.FollowMode getFollow() {
            return this.follow;
        }

        @Override
        public final software.amazon.awscdk.core.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        public final software.amazon.awscdk.core.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildArgs() != null) {
                data.set("buildArgs", om.valueToTree(this.getBuildArgs()));
            }
            if (this.getFile() != null) {
                data.set("file", om.valueToTree(this.getFile()));
            }
            if (this.getInvalidation() != null) {
                data.set("invalidation", om.valueToTree(this.getInvalidation()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPlatform() != null) {
                data.set("platform", om.valueToTree(this.getPlatform()));
            }
            if (this.getRepositoryName() != null) {
                data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            }
            if (this.getTarget() != null) {
                data.set("target", om.valueToTree(this.getTarget()));
            }
            if (this.getExtraHash() != null) {
                data.set("extraHash", om.valueToTree(this.getExtraHash()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollow() != null) {
                data.set("follow", om.valueToTree(this.getFollow()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ecs.AssetImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetImageProps.Jsii$Proxy that = (AssetImageProps.Jsii$Proxy) o;

            if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) return false;
            if (this.file != null ? !this.file.equals(that.file) : that.file != null) return false;
            if (this.invalidation != null ? !this.invalidation.equals(that.invalidation) : that.invalidation != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) return false;
            if (this.repositoryName != null ? !this.repositoryName.equals(that.repositoryName) : that.repositoryName != null) return false;
            if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
            if (this.extraHash != null ? !this.extraHash.equals(that.extraHash) : that.extraHash != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.follow != null ? !this.follow.equals(that.follow) : that.follow != null) return false;
            if (this.ignoreMode != null ? !this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode != null) return false;
            return this.followSymlinks != null ? this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildArgs != null ? this.buildArgs.hashCode() : 0;
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.invalidation != null ? this.invalidation.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.platform != null ? this.platform.hashCode() : 0);
            result = 31 * result + (this.repositoryName != null ? this.repositoryName.hashCode() : 0);
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            result = 31 * result + (this.extraHash != null ? this.extraHash.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.follow != null ? this.follow.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            return result;
        }
    }
}
