package software.amazon.awscdk.services.ecs;

/**
 * (experimental) Constructs for types of environment files.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret secret;
 * Secret dbSecret;
 * StringParameter parameter;
 * TaskDefinition taskDefinition;
 * Bucket s3Bucket;
 * ContainerDefinition newContainer = taskDefinition.addContainer("container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryLimitMiB(1024)
 *         .environment(Map.of( // clear text, not for sensitive data
 *                 "STAGE", "prod"))
 *         .environmentFiles(List.of(EnvironmentFile.fromAsset("./demo-env-file.env"), EnvironmentFile.fromBucket(s3Bucket, "assets/demo-env-file.env")))
 *         .secrets(Map.of( // Retrieved from AWS Secrets Manager or AWS Systems Manager Parameter Store at container start-up.
 *                 "SECRET", Secret.fromSecretsManager(secret),
 *                 "DB_PASSWORD", Secret.fromSecretsManager(dbSecret, "password"),  // Reference a specific JSON field, (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "API_KEY", Secret.fromSecretsManagerVersion(secret, SecretVersionInfo.builder().versionId("12345").build(), "apiKey"),  // Reference a specific version of the secret by its version id or version stage (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "PARAMETER", Secret.fromSsmParameter(parameter)))
 *         .build());
 * newContainer.addEnvironment("QUEUE_NAME", "MyQueue");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.767Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.EnvironmentFile")
public abstract class EnvironmentFile extends software.amazon.jsii.JsiiObject {

    protected EnvironmentFile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EnvironmentFile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected EnvironmentFile() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Loads the environment file from a local disk path.
     * <p>
     * @param path Local disk path. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssetEnvironmentFile fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EnvironmentFile.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AssetEnvironmentFile.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * (experimental) Loads the environment file from a local disk path.
     * <p>
     * @param path Local disk path. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssetEnvironmentFile fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EnvironmentFile.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AssetEnvironmentFile.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Loads the environment file from an S3 bucket.
     * <p>
     * @return `S3EnvironmentFile` associated with the specified S3 object.
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     * @param objectVersion Optional S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.S3EnvironmentFile fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.Nullable java.lang.String objectVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EnvironmentFile.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.S3EnvironmentFile.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required"), objectVersion });
    }

    /**
     * (experimental) Loads the environment file from an S3 bucket.
     * <p>
     * @return `S3EnvironmentFile` associated with the specified S3 object.
     * @param bucket The S3 bucket. This parameter is required.
     * @param key The object key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.S3EnvironmentFile fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EnvironmentFile.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.S3EnvironmentFile.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * (experimental) Called when the container is initialized to allow this object to bind to the stack.
     * <p>
     * @param scope The binding scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EnvironmentFileConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.EnvironmentFile {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Called when the container is initialized to allow this object to bind to the stack.
         * <p>
         * @param scope The binding scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EnvironmentFileConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EnvironmentFileConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
