package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The platform version on which to run your service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ScheduledFargateTask scheduledFargateTask = ScheduledFargateTask.Builder.create(this, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(ScheduledFargateTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .memoryLimitMiB(512)
 *                 .build())
 *         .schedule(Schedule.expression("rate(1 minute)"))
 *         .platformVersion(FargatePlatformVersion.LATEST)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.785Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.FargatePlatformVersion")
public enum FargatePlatformVersion {
    /**
     * (experimental) The latest, recommended platform version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    LATEST,
    /**
     * (experimental) Version 1.4.0.
     * <p>
     * Supports EFS endpoints, CAP_SYS_PTRACE Linux capability,
     * network performance metrics in CloudWatch Container Insights,
     * consolidated 20 GB ephemeral volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VERSION1_4,
    /**
     * (experimental) Version 1.3.0.
     * <p>
     * Supports secrets, task recycling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VERSION1_3,
    /**
     * (experimental) Version 1.2.0.
     * <p>
     * Supports private registries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VERSION1_2,
    /**
     * (experimental) Version 1.1.0.
     * <p>
     * Supports task metadata, health checks, service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VERSION1_1,
    /**
     * (experimental) Initial release.
     * <p>
     * Based on Amazon Linux 2017.09.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    VERSION1_0,
}
