package software.amazon.awscdk.services.ecs;

/**
 * (experimental) Network protocol.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TaskDefinition taskDefinition;
 * Cluster cluster;
 * // Add a container to the task definition
 * ContainerDefinition specificContainer = taskDefinition.addContainer("Container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("/aws/aws-example-app"))
 *         .memoryLimitMiB(2048)
 *         .build());
 * // Add a port mapping
 * specificContainer.addPortMappings(PortMapping.builder()
 *         .containerPort(7600)
 *         .protocol(Protocol.TCP)
 *         .build());
 * Ec2Service.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .cloudMapOptions(CloudMapOptions.builder()
 *                 // Create SRV records - useful for bridge networking
 *                 .dnsRecordType(DnsRecordType.SRV)
 *                 // Targets port TCP port 7600 `specificContainer`
 *                 .container(specificContainer)
 *                 .containerPort(7600)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:59.872Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ecs.Protocol")
public enum Protocol {
    /**
     * (experimental) TCP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TCP,
    /**
     * (experimental) UDP.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UDP,
}
