package software.amazon.awscdk.services.efs;

/**
 * (experimental) The Elastic File System implementation of IFileSystem.
 * <p>
 * It creates a new, empty file system in Amazon Elastic File System (Amazon EFS).
 * It also creates mount target (AWS::EFS::MountTarget) implicitly to mount the
 * EFS file system on an Amazon Elastic Compute Cloud (Amazon EC2) instance or another resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .lifecyclePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to infrequent access (IA) storage by default
 *         .performanceMode(PerformanceMode.GENERAL_PURPOSE) // default
 *         .outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy.AFTER_1_ACCESS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.157Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_efs.FileSystem")
public class FileSystem extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.efs.IFileSystem {

    protected FileSystem(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSystem(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_PORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.efs.FileSystem.class, "DEFAULT_PORT", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Constructor for creating a new EFS FileSystem.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public FileSystem(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing File System from the given properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem fromFileSystemAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.FileSystemAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.efs.FileSystem.class, "fromFileSystemAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) create access point from this filesystem.
     * <p>
     * @param id This parameter is required.
     * @param accessPointOptions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.efs.AccessPointOptions accessPointOptions) {
        return software.amazon.jsii.Kernel.call(this, "addAccessPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.AccessPoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), accessPointOptions });
    }

    /**
     * (experimental) create access point from this filesystem.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.AccessPoint addAccessPoint(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "addAccessPoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.AccessPoint.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Grant the actions defined in actions to the given grantee on this File System resource.
     * <p>
     * @param grantee Principal to grant right to. This parameter is required.
     * @param actions The actions to grant. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) The default port File System listens on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.Number DEFAULT_PORT;

    /**
     * (experimental) The security groups/rules used to allow network connections to the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) The ARN of the file system.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemArn() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ID of the file system, assigned by Amazon EFS.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IDependable getMountTargetsAvailable() {
        return software.amazon.jsii.Kernel.get(this, "mountTargetsAvailable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.IDependable.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.efs.FileSystem}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.efs.FileSystem> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.efs.FileSystemProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.efs.FileSystemProps.Builder();
        }

        /**
         * (experimental) VPC to launch the file system in.
         * <p>
         * @return {@code this}
         * @param vpc VPC to launch the file system in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) Whether to enable automatic backups for the file system.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableAutomaticBackups Whether to enable automatic backups for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableAutomaticBackups(final java.lang.Boolean enableAutomaticBackups) {
            this.props.enableAutomaticBackups(enableAutomaticBackups);
            return this;
        }

        /**
         * (experimental) Defines if the data at rest in the file system is encrypted or not.
         * <p>
         * Default: - If your application has the '
         * <p>
         * @return {@code this}
         * @param encrypted Defines if the data at rest in the file system is encrypted or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encrypted(final java.lang.Boolean encrypted) {
            this.props.encrypted(encrypted);
            return this;
        }

        /**
         * (experimental) The file system's name.
         * <p>
         * Default: - CDK generated name
         * <p>
         * @return {@code this}
         * @param fileSystemName The file system's name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder fileSystemName(final java.lang.String fileSystemName) {
            this.props.fileSystemName(fileSystemName);
            return this;
        }

        /**
         * (experimental) The KMS key used for encryption.
         * <p>
         * This is required to encrypt the data at rest if &#64;encrypted is set to true.
         * <p>
         * Default: - if 'encrypted' is true, the default key for EFS (/aws/elasticfilesystem) is used
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key used for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * (experimental) A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
         * <p>
         * Default: - None. EFS will not transition files to the IA storage class.
         * <p>
         * @return {@code this}
         * @param lifecyclePolicy A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecyclePolicy(final software.amazon.awscdk.services.efs.LifecyclePolicy lifecyclePolicy) {
            this.props.lifecyclePolicy(lifecyclePolicy);
            return this;
        }

        /**
         * (experimental) A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class.
         * <p>
         * Default: - None. EFS will not transition files from IA storage to primary storage.
         * <p>
         * @return {@code this}
         * @param outOfInfrequentAccessPolicy A policy used by EFS lifecycle management to transition files from Infrequent Access (IA) storage class to primary storage class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outOfInfrequentAccessPolicy(final software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy outOfInfrequentAccessPolicy) {
            this.props.outOfInfrequentAccessPolicy(outOfInfrequentAccessPolicy);
            return this;
        }

        /**
         * (experimental) The performance mode that the file system will operate under.
         * <p>
         * An Amazon EFS file system's performance mode can't be changed after the file system has been created.
         * Updating this property will replace the file system.
         * <p>
         * Default: PerformanceMode.GENERAL_PURPOSE
         * <p>
         * @return {@code this}
         * @param performanceMode The performance mode that the file system will operate under. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder performanceMode(final software.amazon.awscdk.services.efs.PerformanceMode performanceMode) {
            this.props.performanceMode(performanceMode);
            return this;
        }

        /**
         * (experimental) Provisioned throughput for the file system.
         * <p>
         * This is a required property if the throughput mode is set to PROVISIONED.
         * Must be at least 1MiB/s.
         * <p>
         * Default: - none, errors out
         * <p>
         * @return {@code this}
         * @param provisionedThroughputPerSecond Provisioned throughput for the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder provisionedThroughputPerSecond(final software.amazon.awscdk.core.Size provisionedThroughputPerSecond) {
            this.props.provisionedThroughputPerSecond(provisionedThroughputPerSecond);
            return this;
        }

        /**
         * (experimental) The removal policy to apply to the file system.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * (experimental) Security Group to assign to this file system.
         * <p>
         * Default: - creates new security group which allows all outbound traffic
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to assign to this file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * (experimental) Enum to mention the throughput mode of the file system.
         * <p>
         * Default: ThroughputMode.BURSTING
         * <p>
         * @return {@code this}
         * @param throughputMode Enum to mention the throughput mode of the file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder throughputMode(final software.amazon.awscdk.services.efs.ThroughputMode throughputMode) {
            this.props.throughputMode(throughputMode);
            return this;
        }

        /**
         * (experimental) Which subnets to place the mount target in the VPC.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Which subnets to place the mount target in the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.efs.FileSystem}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.efs.FileSystem build() {
            return new software.amazon.awscdk.services.efs.FileSystem(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
