package software.amazon.awscdk.services.eks;

/**
 * (experimental) Defines an EKS cluster that runs entirely on AWS Fargate.
 * <p>
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * <code>addFargateProfile</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FargateCluster cluster = FargateCluster.Builder.create(this, "MyCluster")
 *         .version(KubernetesVersion.V1_21)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.371Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks.FargateCluster")
public class FargateCluster extends software.amazon.awscdk.services.eks.Cluster {

    protected FargateCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FargateCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public FargateCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Fargate Profile that was created with the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.FargateProfile getDefaultProfile() {
        return software.amazon.jsii.Kernel.get(this, "defaultProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.FargateProfile.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.FargateCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.FargateCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.FargateClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.FargateClusterProps.Builder();
        }

        /**
         * (experimental) The Kubernetes version to run in the cluster.
         * <p>
         * @return {@code this}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(final software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.props.version(version);
            return this;
        }

        /**
         * (experimental) Name for the cluster.
         * <p>
         * Default: - Automatically generated name
         * <p>
         * @return {@code this}
         * @param clusterName Name for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputClusterName(final java.lang.Boolean outputClusterName) {
            this.props.outputClusterName(outputClusterName);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
         * <p>
         * This command will include
         * the cluster name and, if applicable, the ARN of the masters IAM role.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param outputConfigCommand Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputConfigCommand(final java.lang.Boolean outputConfigCommand) {
            this.props.outputConfigCommand(outputConfigCommand);
            return this;
        }

        /**
         * (experimental) Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) Security Group to use for Control Plane ENIs.
         * <p>
         * Default: - A security group is automatically created
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to use for Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * (experimental) The VPC in which to create the Cluster.
         * <p>
         * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) Where to place EKS Control Plane ENIs.
         * <p>
         * If you want to create public load balancers, this must include public subnets.
         * <p>
         * For example, to only select private subnets, supply the following:
         * <p>
         * <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_NAT }]</code>
         * <p>
         * Default: - All public and private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place EKS Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * (experimental) Install the AWS Load Balancer Controller onto the cluster.
         * <p>
         * Default: - The controller is not installed.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes-sigs.github.io/aws-load-balancer-controller">https://kubernetes-sigs.github.io/aws-load-balancer-controller</a>
         * @param albController Install the AWS Load Balancer Controller onto the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder albController(final software.amazon.awscdk.services.eks.AlbControllerOptions albController) {
            this.props.albController(albController);
            return this;
        }

        /**
         * (experimental) Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param clusterHandlerEnvironment Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterHandlerEnvironment(final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment) {
            this.props.clusterHandlerEnvironment(clusterHandlerEnvironment);
            return this;
        }

        /**
         * (experimental) A security group to associate with the Cluster Handler's Lambdas.
         * <p>
         * The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         * <p>
         * Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * <p>
         * Default: - No security group.
         * <p>
         * @return {@code this}
         * @param clusterHandlerSecurityGroup A security group to associate with the Cluster Handler's Lambdas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterHandlerSecurityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup) {
            this.props.clusterHandlerSecurityGroup(clusterHandlerSecurityGroup);
            return this;
        }

        /**
         * (experimental) Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
         * <p>
         * Default: CoreDnsComputeType.EC2 (for `FargateCluster` the default is FARGATE)
         * <p>
         * @return {@code this}
         * @param coreDnsComputeType Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder coreDnsComputeType(final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType) {
            this.props.coreDnsComputeType(coreDnsComputeType);
            return this;
        }

        /**
         * (experimental) Configure access to the Kubernetes API server endpoint..
         * <p>
         * Default: EndpointAccess.PUBLIC_AND_PRIVATE
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html">https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html</a>
         * @param endpointAccess Configure access to the Kubernetes API server endpoint.. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpointAccess(final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess) {
            this.props.endpointAccess(endpointAccess);
            return this;
        }

        /**
         * (experimental) Environment variables for the kubectl execution.
         * <p>
         * Only relevant for kubectl enabled clusters.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param kubectlEnvironment Environment variables for the kubectl execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlEnvironment(final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.props.kubectlEnvironment(kubectlEnvironment);
            return this;
        }

        /**
         * (experimental) An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
         * <p>
         * By default, the provider will use the layer included in the
         * "aws-lambda-layer-kubectl" SAR application which is available in all
         * commercial regions.
         * <p>
         * To deploy the layer locally, visit
         * https://github.com/aws-samples/aws-lambda-layer-kubectl/blob/master/cdk/README.md
         * for instructions on how to prepare the .zip file and then define it in your
         * app as follows:
         * <p>
         * <blockquote><pre>
         * LayerVersion layer = LayerVersion.Builder.create(this, "kubectl-layer")
         *         .code(Code.fromAsset(String.format("%s/layer.zip", __dirname)))
         *         .compatibleRuntimes(List.of(Runtime.PROVIDED))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - the layer provided by the `aws-lambda-layer-kubectl` SAR app.
         * <p>
         * @return {@code this}
         * @see <a href="https://github.com/aws-samples/aws-lambda-layer-kubectl">https://github.com/aws-samples/aws-lambda-layer-kubectl</a>
         * @param kubectlLayer An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlLayer(final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.props.kubectlLayer(kubectlLayer);
            return this;
        }

        /**
         * (experimental) Amount of memory to allocate to the provider's lambda function.
         * <p>
         * Default: Size.gibibytes(1)
         * <p>
         * @return {@code this}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlMemory(final software.amazon.awscdk.core.Size kubectlMemory) {
            this.props.kubectlMemory(kubectlMemory);
            return this;
        }

        /**
         * (experimental) An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
         * <p>
         * Default: - a role that assumable by anyone with permissions in the same
         * account will automatically be defined
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings">https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings</a>
         * @param mastersRole An IAM role that will be added to the `system:masters` Kubernetes RBAC group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mastersRole(final software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.props.mastersRole(mastersRole);
            return this;
        }

        /**
         * (experimental) An AWS Lambda Layer which includes the NPM dependency `proxy-agent`.
         * <p>
         * This layer
         * is used by the onEvent handler to route AWS SDK requests through a proxy.
         * <p>
         * By default, the provider will use the layer included in the
         * "aws-lambda-layer-node-proxy-agent" SAR application which is available in all
         * commercial regions.
         * <p>
         * To deploy the layer locally define it in your app as follows:
         * <p>
         * <blockquote><pre>
         * LayerVersion layer = LayerVersion.Builder.create(this, "proxy-agent-layer")
         *         .code(Code.fromAsset(String.format("%s/layer.zip", __dirname)))
         *         .compatibleRuntimes(List.of(Runtime.NODEJS_14_X))
         *         .build();
         * </pre></blockquote>
         * <p>
         * Default: - a layer bundled with this module.
         * <p>
         * @return {@code this}
         * @param onEventLayer An AWS Lambda Layer which includes the NPM dependency `proxy-agent`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onEventLayer(final software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer) {
            this.props.onEventLayer(onEventLayer);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputMastersRoleArn(final java.lang.Boolean outputMastersRoleArn) {
            this.props.outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        /**
         * (experimental) If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the `vpcSubnets` selection strategy.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param placeClusterHandlerInVpc If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the `vpcSubnets` selection strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder placeClusterHandlerInVpc(final java.lang.Boolean placeClusterHandlerInVpc) {
            this.props.placeClusterHandlerInVpc(placeClusterHandlerInVpc);
            return this;
        }

        /**
         * (experimental) Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
         * <p>
         * When this is enabled (default), prune labels will be
         * allocated and injected to each resource. These labels will then be used
         * when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param prune Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * (experimental) KMS secret for envelope encryption for Kubernetes secrets.
         * <p>
         * Default: - By default, Kubernetes stores all secret object data within etcd and
         *   all etcd volumes used by Amazon EKS are encrypted at the disk-level
         *   using AWS-Managed encryption keys.
         * <p>
         * @return {@code this}
         * @param secretsEncryptionKey KMS secret for envelope encryption for Kubernetes secrets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretsEncryptionKey(final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey) {
            this.props.secretsEncryptionKey(secretsEncryptionKey);
            return this;
        }

        /**
         * (experimental) The CIDR block to assign Kubernetes service IP addresses from.
         * <p>
         * Default: - Kubernetes assigns addresses from either the
         *   10.100.0.0/16 or 172.20.0.0/16 CIDR blocks
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr">https://docs.aws.amazon.com/eks/latest/APIReference/API_KubernetesNetworkConfigRequest.html#AmazonEKS-Type-KubernetesNetworkConfigRequest-serviceIpv4Cidr</a>
         * @param serviceIpv4Cidr The CIDR block to assign Kubernetes service IP addresses from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceIpv4Cidr(final java.lang.String serviceIpv4Cidr) {
            this.props.serviceIpv4Cidr(serviceIpv4Cidr);
            return this;
        }

        /**
         * (experimental) Fargate Profile to create along with the cluster.
         * <p>
         * Default: - A profile called "default" with 'default' and 'kube-system'
         *   selectors will be created if this is left undefined.
         * <p>
         * @return {@code this}
         * @param defaultProfile Fargate Profile to create along with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultProfile(final software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile) {
            this.props.defaultProfile(defaultProfile);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.FargateCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.FargateCluster build() {
            return new software.amazon.awscdk.services.eks.FargateCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
