package software.amazon.awscdk.services.eks;

/**
 * (experimental) Represents a manifest within the Kubernetes system.
 * <p>
 * Alternatively, you can use <code>cluster.addManifest(resource[, resource, ...])</code>
 * to define resources on this cluster.
 * <p>
 * Applies/deletes the manifest using <code>kubectl</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * KubernetesManifest namespace = cluster.addManifest("my-namespace", Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Namespace",
 *         "metadata", Map.of("name", "my-app")));
 * KubernetesManifest service = cluster.addManifest("my-service", Map.of(
 *         "metadata", Map.of(
 *                 "name", "myservice",
 *                 "namespace", "my-app"),
 *         "spec", Map.of()));
 * service.node.addDependency(namespace);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.396Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks.KubernetesManifest")
public class KubernetesManifest extends software.amazon.awscdk.core.Construct {

    protected KubernetesManifest(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesManifest(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesManifest.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public KubernetesManifest(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesManifestProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) The CloudFormation reosurce type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.KubernetesManifest}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.KubernetesManifest> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.KubernetesManifestProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.KubernetesManifestProps.Builder();
        }

        /**
         * (experimental) Automatically detect `Ingress` resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param ingressAlb Automatically detect `Ingress` resources in the manifest and annotate them so they are picked up by an ALB Ingress Controller. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ingressAlb(final java.lang.Boolean ingressAlb) {
            this.props.ingressAlb(ingressAlb);
            return this;
        }

        /**
         * (experimental) Specify the ALB scheme that should be applied to `Ingress` resources.
         * <p>
         * Only applicable if <code>ingressAlb</code> is set to <code>true</code>.
         * <p>
         * Default: AlbScheme.INTERNAL
         * <p>
         * @return {@code this}
         * @param ingressAlbScheme Specify the ALB scheme that should be applied to `Ingress` resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder ingressAlbScheme(final software.amazon.awscdk.services.eks.AlbScheme ingressAlbScheme) {
            this.props.ingressAlbScheme(ingressAlbScheme);
            return this;
        }

        /**
         * (experimental) When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted.
         * <p>
         * To address this, <code>kubectl apply</code> has a <code>--prune</code> option which will
         * query the cluster for all resources with a specific label and will remove
         * all the labeld resources that are not part of the applied manifest. If this
         * option is disabled and a resource is removed, it will become "orphaned" and
         * will not be deleted from the cluster.
         * <p>
         * When this option is enabled (default), the construct will inject a label to
         * all Kubernetes resources included in this manifest which will be used to
         * prune resources when the manifest changes via <code>kubectl apply --prune</code>.
         * <p>
         * The label name will be <code>aws.cdk.eks/prune-&lt;ADDR&gt;</code> where <code>&lt;ADDR&gt;</code> is the
         * 42-char unique address of this construct in the construct tree. Value is
         * empty.
         * <p>
         * Default: - based on the prune option of the cluster, which is `true` unless
         * otherwise specified.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label">https://kubernetes.io/docs/tasks/manage-kubernetes-objects/declarative-config/#alternative-kubectl-apply-f-directory-prune-l-your-label</a>
         * @param prune When a resource is removed from a Kubernetes manifest, it no longer appears in the manifest, and there is no way to know that this resource needs to be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(final java.lang.Boolean prune) {
            this.props.prune(prune);
            return this;
        }

        /**
         * (experimental) A flag to signify if the manifest validation should be skipped.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param skipValidation A flag to signify if the manifest validation should be skipped. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder skipValidation(final java.lang.Boolean skipValidation) {
            this.props.skipValidation(skipValidation);
            return this;
        }

        /**
         * (experimental) The EKS cluster to apply this manifest to.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to apply this manifest to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * (experimental) The manifest to apply.
         * <p>
         * Consists of any number of child resources.
         * <p>
         * When the resources are created/updated, this manifest will be applied to the
         * cluster through <code>kubectl apply</code> and when the resources or the stack is
         * deleted, the resources in the manifest will be deleted through <code>kubectl delete</code>.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * List.of(Map.of(
         *         "apiVersion", "v1",
         *         "kind", "Pod",
         *         "metadata", Map.of("name", "mypod"),
         *         "spec", Map.of(
         *                 "containers", List.of(Map.of("name", "hello", "image", "paulbouwer/hello-kubernetes:1.5", "ports", List.of(Map.of("containerPort", 8080)))))));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param manifest The manifest to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder manifest(final java.util.List<? extends java.util.Map<java.lang.String, ? extends java.lang.Object>> manifest) {
            this.props.manifest(manifest);
            return this;
        }

        /**
         * (experimental) Overwrite any existing resources.
         * <p>
         * If this is set, we will use <code>kubectl apply</code> instead of <code>kubectl create</code>
         * when the resource is created. Otherwise, if there is already a resource
         * in the cluster with the same name, the operation will fail.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param overwrite Overwrite any existing resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder overwrite(final java.lang.Boolean overwrite) {
            this.props.overwrite(overwrite);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.KubernetesManifest}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.KubernetesManifest build() {
            return new software.amazon.awscdk.services.eks.KubernetesManifest(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
