package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) Options for adding an AutoScalingGroup as capacity.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.legacy.*;
 * AutoScalingGroupOptions autoScalingGroupOptions = AutoScalingGroupOptions.builder()
 *         .bootstrapEnabled(false)
 *         .bootstrapOptions(BootstrapOptions.builder()
 *                 .additionalArgs("additionalArgs")
 *                 .awsApiRetryAttempts(123)
 *                 .dockerConfigJson("dockerConfigJson")
 *                 .enableDockerBridge(false)
 *                 .kubeletExtraArgs("kubeletExtraArgs")
 *                 .useMaxPods(false)
 *                 .build())
 *         .mapRole(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.466Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.AutoScalingGroupOptions")
@software.amazon.jsii.Jsii.Proxy(AutoScalingGroupOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AutoScalingGroupOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
     * <p>
     * If you wish to provide a custom user data script, set this to <code>false</code> and
     * manually invoke <code>autoscalingGroup.addUserData()</code>.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getBootstrapEnabled() {
        return null;
    }

    /**
     * (experimental) Allows options for node bootstrapping through EC2 user data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.legacy.BootstrapOptions getBootstrapOptions() {
        return null;
    }

    /**
     * (experimental) Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
     * <p>
     * This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
     * <p>
     * Default: - true if the cluster has kubectl enabled (which is the default).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMapRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupOptions> {
        java.lang.Boolean bootstrapEnabled;
        software.amazon.awscdk.services.eks.legacy.BootstrapOptions bootstrapOptions;
        java.lang.Boolean mapRole;

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getBootstrapEnabled}
         * @param bootstrapEnabled Configures the EC2 user-data script for instances in this autoscaling group to bootstrap the node (invoke `/etc/eks/bootstrap.sh`) and associate it with the EKS cluster.
         *                         If you wish to provide a custom user data script, set this to <code>false</code> and
         *                         manually invoke <code>autoscalingGroup.addUserData()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapEnabled(java.lang.Boolean bootstrapEnabled) {
            this.bootstrapEnabled = bootstrapEnabled;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getBootstrapOptions}
         * @param bootstrapOptions Allows options for node bootstrapping through EC2 user data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bootstrapOptions(software.amazon.awscdk.services.eks.legacy.BootstrapOptions bootstrapOptions) {
            this.bootstrapOptions = bootstrapOptions;
            return this;
        }

        /**
         * Sets the value of {@link AutoScalingGroupOptions#getMapRole}
         * @param mapRole Will automatically update the aws-auth ConfigMap to map the IAM instance role to RBAC.
         *                This cannot be explicitly set to <code>true</code> if the cluster has kubectl disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mapRole(java.lang.Boolean mapRole) {
            this.mapRole = mapRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AutoScalingGroupOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AutoScalingGroupOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AutoScalingGroupOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupOptions {
        private final java.lang.Boolean bootstrapEnabled;
        private final software.amazon.awscdk.services.eks.legacy.BootstrapOptions bootstrapOptions;
        private final java.lang.Boolean mapRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bootstrapEnabled = software.amazon.jsii.Kernel.get(this, "bootstrapEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.bootstrapOptions = software.amazon.jsii.Kernel.get(this, "bootstrapOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.BootstrapOptions.class));
            this.mapRole = software.amazon.jsii.Kernel.get(this, "mapRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bootstrapEnabled = builder.bootstrapEnabled;
            this.bootstrapOptions = builder.bootstrapOptions;
            this.mapRole = builder.mapRole;
        }

        @Override
        public final java.lang.Boolean getBootstrapEnabled() {
            return this.bootstrapEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.eks.legacy.BootstrapOptions getBootstrapOptions() {
            return this.bootstrapOptions;
        }

        @Override
        public final java.lang.Boolean getMapRole() {
            return this.mapRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBootstrapEnabled() != null) {
                data.set("bootstrapEnabled", om.valueToTree(this.getBootstrapEnabled()));
            }
            if (this.getBootstrapOptions() != null) {
                data.set("bootstrapOptions", om.valueToTree(this.getBootstrapOptions()));
            }
            if (this.getMapRole() != null) {
                data.set("mapRole", om.valueToTree(this.getMapRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_eks_legacy.AutoScalingGroupOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AutoScalingGroupOptions.Jsii$Proxy that = (AutoScalingGroupOptions.Jsii$Proxy) o;

            if (this.bootstrapEnabled != null ? !this.bootstrapEnabled.equals(that.bootstrapEnabled) : that.bootstrapEnabled != null) return false;
            if (this.bootstrapOptions != null ? !this.bootstrapOptions.equals(that.bootstrapOptions) : that.bootstrapOptions != null) return false;
            return this.mapRole != null ? this.mapRole.equals(that.mapRole) : that.mapRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bootstrapEnabled != null ? this.bootstrapEnabled.hashCode() : 0;
            result = 31 * result + (this.bootstrapOptions != null ? this.bootstrapOptions.hashCode() : 0);
            result = 31 * result + (this.mapRole != null ? this.mapRole.hashCode() : 0);
            return result;
        }
    }
}
