package software.amazon.awscdk.services.eks.legacy;

/**
 * (experimental) A Cluster represents a managed Kubernetes Service (EKS).
 * <p>
 * This is a fully managed cluster of API Servers (control-plane)
 * The user is still required to create the worker nodes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // option 1: use a construct
 * // option 1: use a construct
 * HelmChart.Builder.create(this, "NginxIngress")
 *         .cluster(cluster)
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build();
 * // or, option2: use `addChart`
 * cluster.addChart("NginxIngress", HelmChartOptions.builder()
 *         .chart("nginx-ingress")
 *         .repository("https://helm.nginx.com/stable")
 *         .namespace("kube-system")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.Cluster")
public class Cluster extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.eks.legacy.ICluster {

    protected Cluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Cluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Initiates an EKS Cluster with the supplied arguments.
     * <p>
     * @param scope a Construct, most likely a cdk.Stack created. This parameter is required.
     * @param id This parameter is required.
     * @param props properties in the IClusterProps interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Cluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.legacy.ClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Initiates an EKS Cluster with the supplied arguments.
     * <p>
     * @param scope a Construct, most likely a cdk.Stack created. This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Cluster(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import an existing cluster.
     * <p>
     * @param scope the construct scope, in most cases 'this'. This parameter is required.
     * @param id the id or name to import as. This parameter is required.
     * @param attrs the cluster properties to use for importing information. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.ICluster fromClusterAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.ClusterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.legacy.Cluster.class, "fromClusterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.ICluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Add compute capacity to this EKS cluster in the form of an AutoScalingGroup.
     * <p>
     * The AutoScalingGroup must be running an EKS-optimized AMI containing the
     * /etc/eks/bootstrap.sh script. This method will configure Security Groups,
     * add the right policies to the instance role, apply the right tags, and add
     * the required user data to the instance's launch configuration.
     * <p>
     * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
     * If kubectl is enabled, the
     * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
     * daemon will be installed on all spot instances to handle
     * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
     * <p>
     * Prefer to use <code>addCapacity</code> if possible.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html">https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html</a>
     * @param autoScalingGroup [disable-awslint:ref-via-interface]. This parameter is required.
     * @param options options for adding auto scaling groups, like customizing the bootstrap script. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addAutoScalingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup autoScalingGroup, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.AutoScalingGroupOptions options) {
        software.amazon.jsii.Kernel.call(this, "addAutoScalingGroup", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Add nodes to this EKS cluster.
     * <p>
     * The nodes will automatically be configured with the right VPC and AMI
     * for the instance type and Kubernetes version.
     * <p>
     * Spot instances will be labeled <code>lifecycle=Ec2Spot</code> and tainted with <code>PreferNoSchedule</code>.
     * If kubectl is enabled, the
     * <a href="https://github.com/awslabs/ec2-spot-labs/tree/master/ec2-spot-eks-solution/spot-termination-handler">spot interrupt handler</a>
     * daemon will be installed on all spot instances to handle
     * <a href="https://aws.amazon.com/blogs/aws/new-ec2-spot-instance-termination-notices/">EC2 Spot Instance Termination Notices</a>.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AutoScalingGroup addCapacity(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.CapacityOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Defines a Helm chart in this cluster.
     * <p>
     * @return a `HelmChart` object
     * @param id logical id of this chart. This parameter is required.
     * @param options options of this chart. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.HelmChart addChart(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.HelmChartOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addChart", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.HelmChart.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Defines a Kubernetes resource in this cluster.
     * <p>
     * The manifest will be applied/deleted using kubectl as needed.
     * <p>
     * @return a `KubernetesResource` object.
     * @param id logical id of this manifest. This parameter is required.
     * @param manifest a list of Kubernetes resource specifications. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.KubernetesResource addResource(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.Object... manifest) {
        return software.amazon.jsii.Kernel.call(this, "addResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.KubernetesResource.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(id, "id is required") }), java.util.Arrays.<Object>stream(manifest)).toArray(Object[]::new));
    }

    /**
     * (experimental) Lazily creates the AwsAuth resource, which manages AWS authentication mapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.AwsAuth getAwsAuth() {
        return software.amazon.jsii.Kernel.get(this, "awsAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.AwsAuth.class));
    }

    /**
     * (experimental) The AWS generated ARN for the Cluster resource.
     * <p>
     * For example, <code>arn:aws:eks:us-west-2:666666666666:cluster/prod</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The certificate-authority-data for your cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData() {
        return software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The endpoint URL for the Cluster.
     * <p>
     * This is the URL inside the kubeconfig file to use with kubectl
     * <p>
     * For example, <code>https://5E1D0CEXAMPLEA591B746AFC5AB30262.yl4.us-west-2.eks.amazonaws.com</code>
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The Name of the created EKS Cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Manages connection rules (Security Group Rules) for the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) Indicates if `kubectl` related operations can be performed on this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getKubectlEnabled() {
        return software.amazon.jsii.Kernel.get(this, "kubectlEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) IAM role assumed by the EKS Control Plane.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The VPC in which this Cluster was created.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * (experimental) The auto scaling group that hosts the default capacity for this cluster.
     * <p>
     * This will be <code>undefined</code> if the default capacity is set to 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.AutoScalingGroup getDefaultCapacity() {
        return software.amazon.jsii.Kernel.get(this, "defaultCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AutoScalingGroup.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.eks.legacy.Cluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.legacy.Cluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope a Construct, most likely a cdk.Stack created. This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.eks.legacy.ClusterProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Name for the cluster.
         * <p>
         * Default: - Automatically generated name
         * <p>
         * @return {@code this}
         * @param clusterName Name for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * (experimental) Number of instances to allocate as an initial capacity for this cluster.
         * <p>
         * Instance type can be configured through <code>defaultCapacityInstanceType</code>,
         * which defaults to <code>m5.large</code>.
         * <p>
         * Use <code>cluster.addCapacity</code> to add additional customized capacity. Set this
         * to <code>0</code> is you wish to avoid the initial capacity allocation.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param defaultCapacity Number of instances to allocate as an initial capacity for this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultCapacity(final java.lang.Number defaultCapacity) {
            this.props().defaultCapacity(defaultCapacity);
            return this;
        }

        /**
         * (experimental) The instance type to use for the default capacity.
         * <p>
         * This will only be taken
         * into account if <code>defaultCapacity</code> is &gt; 0.
         * <p>
         * Default: m5.large
         * <p>
         * @return {@code this}
         * @param defaultCapacityInstance The instance type to use for the default capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultCapacityInstance(final software.amazon.awscdk.services.ec2.InstanceType defaultCapacityInstance) {
            this.props().defaultCapacityInstance(defaultCapacityInstance);
            return this;
        }

        /**
         * (experimental) Allows defining `kubectrl`-related resources on this cluster.
         * <p>
         * If this is disabled, it will not be possible to use the following
         * capabilities:
         * <p>
         * <ul>
         * <li><code>addResource</code></li>
         * <li><code>addRoleMapping</code></li>
         * <li><code>addUserMapping</code></li>
         * <li><code>addMastersRole</code> and <code>props.mastersRole</code></li>
         * </ul>
         * <p>
         * If this is disabled, the cluster can only be managed by issuing <code>kubectl</code>
         * commands from a session that uses the IAM role/user that created the
         * account.
         * <p>
         * <em>NOTE</em>: changing this value will destoy the cluster. This is because a
         * managable cluster must be created using an AWS CloudFormation custom
         * resource which executes with an IAM role owned by the CDK app.
         * <p>
         * Default: true The cluster can be managed by the AWS CDK application.
         * <p>
         * @return {@code this}
         * @param kubectlEnabled Allows defining `kubectrl`-related resources on this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlEnabled(final java.lang.Boolean kubectlEnabled) {
            this.props().kubectlEnabled(kubectlEnabled);
            return this;
        }

        /**
         * (experimental) An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
         * <p>
         * Default: - By default, it will only possible to update this Kubernetes
         *   system by adding resources to this cluster via `addResource` or
         *   by defining `KubernetesResource` resources in your AWS CDK app.
         *   Use this if you wish to grant cluster administration privileges
         *   to another role.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings">https://kubernetes.io/docs/reference/access-authn-authz/rbac/#default-roles-and-role-bindings</a>
         * @param mastersRole An IAM role that will be added to the `system:masters` Kubernetes RBAC group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mastersRole(final software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.props().mastersRole(mastersRole);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputClusterName(final java.lang.Boolean outputClusterName) {
            this.props().outputClusterName(outputClusterName);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
         * <p>
         * This command will include
         * the cluster name and, if applicable, the ARN of the masters IAM role.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param outputConfigCommand Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputConfigCommand(final java.lang.Boolean outputConfigCommand) {
            this.props().outputConfigCommand(outputConfigCommand);
            return this;
        }

        /**
         * (experimental) Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputMastersRoleArn(final java.lang.Boolean outputMastersRoleArn) {
            this.props().outputMastersRoleArn(outputMastersRoleArn);
            return this;
        }

        /**
         * (experimental) Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * <p>
         * Default: - A role is automatically created for you
         * <p>
         * @return {@code this}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) Security Group to use for Control Plane ENIs.
         * <p>
         * Default: - A security group is automatically created
         * <p>
         * @return {@code this}
         * @param securityGroup Security Group to use for Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props().securityGroup(securityGroup);
            return this;
        }

        /**
         * (experimental) The Kubernetes version to run in the cluster.
         * <p>
         * Default: - If not supplied, will use Amazon default version
         * <p>
         * @return {@code this}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(final java.lang.String version) {
            this.props().version(version);
            return this;
        }

        /**
         * (experimental) The VPC in which to create the Cluster.
         * <p>
         * Default: - a VPC with default configuration will be created and can be accessed through `cluster.vpc`.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which to create the Cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * (experimental) Where to place EKS Control Plane ENIs.
         * <p>
         * If you want to create public load balancers, this must include public subnets.
         * <p>
         * For example, to only select private subnets, supply the following:
         * <p>
         * <blockquote><pre>
         * Map&lt;String, SubnetType&gt;[] vpcSubnets = List.of(Map.of("subnetType", SubnetType.PRIVATE_WITH_NAT));
         * </pre></blockquote>
         * <p>
         * Default: - All public and private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place EKS Control Plane ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.props().vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.legacy.Cluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.eks.legacy.Cluster build() {
            return new software.amazon.awscdk.services.eks.legacy.Cluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.eks.legacy.ClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.eks.legacy.ClusterProps.Builder();
            }
            return this.props;
        }
    }
}
