package software.amazon.awscdk.services.eks.legacy;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.legacy.*;
 * SecurityGroup securityGroup;
 * Vpc vpc;
 * ClusterAttributes clusterAttributes = ClusterAttributes.builder()
 *         .clusterArn("clusterArn")
 *         .clusterCertificateAuthorityData("clusterCertificateAuthorityData")
 *         .clusterEndpoint("clusterEndpoint")
 *         .clusterName("clusterName")
 *         .securityGroups(List.of(securityGroup))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.ClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(ClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The unique ARN assigned to the service by AWS in the form of arn:aws:eks:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

    /**
     * (experimental) The certificate-authority-data for your cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterCertificateAuthorityData();

    /**
     * (experimental) The API Server endpoint URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterEndpoint();

    /**
     * (experimental) The physical name of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * (experimental) The security groups associated with this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups();

    /**
     * (experimental) The VPC in which this Cluster was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * @return a {@link Builder} of {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ClusterAttributes> {
        java.lang.String clusterArn;
        java.lang.String clusterCertificateAuthorityData;
        java.lang.String clusterEndpoint;
        java.lang.String clusterName;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ClusterAttributes#getClusterArn}
         * @param clusterArn The unique ARN assigned to the service by AWS in the form of arn:aws:eks:. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterArn(java.lang.String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterCertificateAuthorityData}
         * @param clusterCertificateAuthorityData The certificate-authority-data for your cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterCertificateAuthorityData(java.lang.String clusterCertificateAuthorityData) {
            this.clusterCertificateAuthorityData = clusterCertificateAuthorityData;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterEndpoint}
         * @param clusterEndpoint The API Server endpoint URL. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getClusterName}
         * @param clusterName The physical name of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getSecurityGroups}
         * @param securityGroups The security groups associated with this cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ClusterAttributes#getVpc}
         * @param vpc The VPC in which this Cluster was created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterAttributes {
        private final java.lang.String clusterArn;
        private final java.lang.String clusterCertificateAuthorityData;
        private final java.lang.String clusterEndpoint;
        private final java.lang.String clusterName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterCertificateAuthorityData = software.amazon.jsii.Kernel.get(this, "clusterCertificateAuthorityData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterArn = java.util.Objects.requireNonNull(builder.clusterArn, "clusterArn is required");
            this.clusterCertificateAuthorityData = java.util.Objects.requireNonNull(builder.clusterCertificateAuthorityData, "clusterCertificateAuthorityData is required");
            this.clusterEndpoint = java.util.Objects.requireNonNull(builder.clusterEndpoint, "clusterEndpoint is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)java.util.Objects.requireNonNull(builder.securityGroups, "securityGroups is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
        }

        @Override
        public final java.lang.String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final java.lang.String getClusterCertificateAuthorityData() {
            return this.clusterCertificateAuthorityData;
        }

        @Override
        public final java.lang.String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterArn", om.valueToTree(this.getClusterArn()));
            data.set("clusterCertificateAuthorityData", om.valueToTree(this.getClusterCertificateAuthorityData()));
            data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            data.set("vpc", om.valueToTree(this.getVpc()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_eks_legacy.ClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ClusterAttributes.Jsii$Proxy that = (ClusterAttributes.Jsii$Proxy) o;

            if (!clusterArn.equals(that.clusterArn)) return false;
            if (!clusterCertificateAuthorityData.equals(that.clusterCertificateAuthorityData)) return false;
            if (!clusterEndpoint.equals(that.clusterEndpoint)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (!securityGroups.equals(that.securityGroups)) return false;
            return this.vpc.equals(that.vpc);
        }

        @Override
        public final int hashCode() {
            int result = this.clusterArn.hashCode();
            result = 31 * result + (this.clusterCertificateAuthorityData.hashCode());
            result = 31 * result + (this.clusterEndpoint.hashCode());
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.securityGroups.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            return result;
        }
    }
}
