package software.amazon.awscdk.services.eks.legacy;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * Map&lt;String, String&gt; appLabel = Map.of("app", "hello-kubernetes");
 * Map&lt;String, Object&gt; deployment = Map.of(
 *         "apiVersion", "apps/v1",
 *         "kind", "Deployment",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "replicas", 3,
 *                 "selector", Map.of("matchLabels", appLabel),
 *                 "template", Map.of(
 *                         "metadata", Map.of("labels", appLabel),
 *                         "spec", Map.of(
 *                                 "containers", List.of(Map.of(
 *                                         "name", "hello-kubernetes",
 *                                         "image", "paulbouwer/hello-kubernetes:1.5",
 *                                         "ports", List.of(Map.of("containerPort", 8080))))))));
 * Map&lt;String, Object&gt; service = Map.of(
 *         "apiVersion", "v1",
 *         "kind", "Service",
 *         "metadata", Map.of("name", "hello-kubernetes"),
 *         "spec", Map.of(
 *                 "type", "LoadBalancer",
 *                 "ports", List.of(Map.of("port", 80, "targetPort", 8080)),
 *                 "selector", appLabel));
 * // option 1: use a construct
 * // option 1: use a construct
 * KubernetesResource.Builder.create(this, "hello-kub")
 *         .cluster(cluster)
 *         .manifest(List.of(deployment, service))
 *         .build();
 * // or, option2: use `addResource`
 * cluster.addResource("hello-kub", service, deployment);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.557Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_eks_legacy.KubernetesResourceProps")
@software.amazon.jsii.Jsii.Proxy(KubernetesResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface KubernetesResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The EKS cluster to apply this configuration to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.legacy.Cluster getCluster();

    /**
     * (experimental) The resource manifest.
     * <p>
     * Consists of any number of child resources.
     * <p>
     * When the resource is created/updated, this manifest will be applied to the
     * cluster through <code>kubectl apply</code> and when the resource or the stack is
     * deleted, the manifest will be deleted through <code>kubectl delete</code>.
     * <p>
     * <blockquote><pre>
     * const manifest = {
     *    apiVersion: 'v1',
     *    kind: 'Pod',
     *    metadata: { name: 'mypod' },
     *    spec: {
     *      containers: [ { name: 'hello', image: 'paulbouwer/hello-kubernetes:1.5', ports: [ { containerPort: 8080 } ] } ]
     *    }
     * }
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> getManifest();

    /**
     * @return a {@link Builder} of {@link KubernetesResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesResourceProps> {
        software.amazon.awscdk.services.eks.legacy.Cluster cluster;
        java.util.List<java.lang.Object> manifest;

        /**
         * Sets the value of {@link KubernetesResourceProps#getCluster}
         * @param cluster The EKS cluster to apply this configuration to. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.eks.legacy.Cluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesResourceProps#getManifest}
         * @param manifest The resource manifest. This parameter is required.
         *                 Consists of any number of child resources.
         *                 <p>
         *                 When the resource is created/updated, this manifest will be applied to the
         *                 cluster through <code>kubectl apply</code> and when the resource or the stack is
         *                 deleted, the manifest will be deleted through <code>kubectl delete</code>.
         *                 <p>
         *                 <blockquote><pre>
         *                 const manifest = {
         *                    apiVersion: 'v1',
         *                    kind: 'Pod',
         *                    metadata: { name: 'mypod' },
         *                    spec: {
         *                      containers: [ { name: 'hello', image: 'paulbouwer/hello-kubernetes:1.5', ports: [ { containerPort: 8080 } ] } ]
         *                    }
         *                 }
         *                 </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder manifest(java.util.List<? extends java.lang.Object> manifest) {
            this.manifest = (java.util.List<java.lang.Object>)manifest;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public KubernetesResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubernetesResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesResourceProps {
        private final software.amazon.awscdk.services.eks.legacy.Cluster cluster;
        private final java.util.List<java.lang.Object> manifest;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.legacy.Cluster.class));
            this.manifest = software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.manifest = (java.util.List<java.lang.Object>)java.util.Objects.requireNonNull(builder.manifest, "manifest is required");
        }

        @Override
        public final software.amazon.awscdk.services.eks.legacy.Cluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<java.lang.Object> getManifest() {
            return this.manifest;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("manifest", om.valueToTree(this.getManifest()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_eks_legacy.KubernetesResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesResourceProps.Jsii$Proxy that = (KubernetesResourceProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            return this.manifest.equals(that.manifest);
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.manifest.hashCode());
            return result;
        }
    }
}
