package software.amazon.awscdk.services.elasticbeanstalk;

/**
 * Properties for defining a `CfnConfigurationTemplate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticbeanstalk.*;
 * CfnConfigurationTemplateProps cfnConfigurationTemplateProps = CfnConfigurationTemplateProps.builder()
 *         .applicationName("applicationName")
 *         // the properties below are optional
 *         .description("description")
 *         .environmentId("environmentId")
 *         .optionSettings(List.of(ConfigurationOptionSettingProperty.builder()
 *                 .namespace("namespace")
 *                 .optionName("optionName")
 *                 // the properties below are optional
 *                 .resourceName("resourceName")
 *                 .value("value")
 *                 .build()))
 *         .platformArn("platformArn")
 *         .solutionStackName("solutionStackName")
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .applicationName("applicationName")
 *                 .templateName("templateName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:00.687Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_elasticbeanstalk.CfnConfigurationTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Elastic Beanstalk application to associate with this configuration template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * An optional description for this configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of an environment whose settings you want to use to create the configuration template.
     * <p>
     * You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code> , <code>SolutionStackName</code> , or <code>SourceConfiguration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentId() {
        return null;
    }

    /**
     * Option values for the Elastic Beanstalk configuration, such as the instance type.
     * <p>
     * If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptionSettings() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the custom platform.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify <code>PlatformArn</code> , then don't specify <code>SolutionStackName</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlatformArn() {
        return null;
    }

    /**
     * The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses.
     * <p>
     * For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code> . A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
     * <p>
     * You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code> , <code>EnvironmentId</code> , or <code>SourceConfiguration</code> .
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"><code>ListAvailableSolutionStacks</code></a> API to obtain a list of available solution stacks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSolutionStackName() {
        return null;
    }

    /**
     * An Elastic Beanstalk configuration template to base this one on.
     * <p>
     * If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.
     * <p>
     * Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code> .
     * <p>
     * You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code> , <code>EnvironmentId</code> , or <code>SolutionStackName</code> .
     * <p>
     * Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationTemplateProps> {
        java.lang.String applicationName;
        java.lang.String description;
        java.lang.String environmentId;
        java.lang.Object optionSettings;
        java.lang.String platformArn;
        java.lang.String solutionStackName;
        java.lang.Object sourceConfiguration;

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getApplicationName}
         * @param applicationName The name of the Elastic Beanstalk application to associate with this configuration template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getDescription}
         * @param description An optional description for this configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getEnvironmentId}
         * @param environmentId The ID of an environment whose settings you want to use to create the configuration template.
         *                      You must specify <code>EnvironmentId</code> if you don't specify <code>PlatformArn</code> , <code>SolutionStackName</code> , or <code>SourceConfiguration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentId(java.lang.String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getOptionSettings}
         * @param optionSettings Option values for the Elastic Beanstalk configuration, such as the instance type.
         *                       If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionSettings(software.amazon.awscdk.core.IResolvable optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getOptionSettings}
         * @param optionSettings Option values for the Elastic Beanstalk configuration, such as the instance type.
         *                       If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html">Option Values</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionSettings(java.util.List<? extends java.lang.Object> optionSettings) {
            this.optionSettings = optionSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getPlatformArn}
         * @param platformArn The Amazon Resource Name (ARN) of the custom platform.
         *                    For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If you specify <code>PlatformArn</code> , then don't specify <code>SolutionStackName</code> .
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformArn(java.lang.String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getSolutionStackName}
         * @param solutionStackName The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses.
         *                          For example, <code>64bit Amazon Linux 2013.09 running Tomcat 7 Java 7</code> . A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html">Supported Platforms</a> in the <em>AWS Elastic Beanstalk Developer Guide</em> .
         *                          <p>
         *                          You must specify <code>SolutionStackName</code> if you don't specify <code>PlatformArn</code> , <code>EnvironmentId</code> , or <code>SourceConfiguration</code> .
         *                          <p>
         *                          Use the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html"><code>ListAvailableSolutionStacks</code></a> API to obtain a list of available solution stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder solutionStackName(java.lang.String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getSourceConfiguration}
         * @param sourceConfiguration An Elastic Beanstalk configuration template to base this one on.
         *                            If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.
         *                            <p>
         *                            Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code> .
         *                            <p>
         *                            You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code> , <code>EnvironmentId</code> , or <code>SolutionStackName</code> .
         *                            <p>
         *                            Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.services.elasticbeanstalk.CfnConfigurationTemplate.SourceConfigurationProperty sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationTemplateProps#getSourceConfiguration}
         * @param sourceConfiguration An Elastic Beanstalk configuration template to base this one on.
         *                            If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.
         *                            <p>
         *                            Values specified in <code>OptionSettings</code> override any values obtained from the <code>SourceConfiguration</code> .
         *                            <p>
         *                            You must specify <code>SourceConfiguration</code> if you don't specify <code>PlatformArn</code> , <code>EnvironmentId</code> , or <code>SolutionStackName</code> .
         *                            <p>
         *                            Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.core.IResolvable sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationTemplateProps {
        private final java.lang.String applicationName;
        private final java.lang.String description;
        private final java.lang.String environmentId;
        private final java.lang.Object optionSettings;
        private final java.lang.String platformArn;
        private final java.lang.String solutionStackName;
        private final java.lang.Object sourceConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentId = software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.optionSettings = software.amazon.jsii.Kernel.get(this, "optionSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.platformArn = software.amazon.jsii.Kernel.get(this, "platformArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.solutionStackName = software.amazon.jsii.Kernel.get(this, "solutionStackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.description = builder.description;
            this.environmentId = builder.environmentId;
            this.optionSettings = builder.optionSettings;
            this.platformArn = builder.platformArn;
            this.solutionStackName = builder.solutionStackName;
            this.sourceConfiguration = builder.sourceConfiguration;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEnvironmentId() {
            return this.environmentId;
        }

        @Override
        public final java.lang.Object getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final java.lang.String getPlatformArn() {
            return this.platformArn;
        }

        @Override
        public final java.lang.String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final java.lang.Object getSourceConfiguration() {
            return this.sourceConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentId() != null) {
                data.set("environmentId", om.valueToTree(this.getEnvironmentId()));
            }
            if (this.getOptionSettings() != null) {
                data.set("optionSettings", om.valueToTree(this.getOptionSettings()));
            }
            if (this.getPlatformArn() != null) {
                data.set("platformArn", om.valueToTree(this.getPlatformArn()));
            }
            if (this.getSolutionStackName() != null) {
                data.set("solutionStackName", om.valueToTree(this.getSolutionStackName()));
            }
            if (this.getSourceConfiguration() != null) {
                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_elasticbeanstalk.CfnConfigurationTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationTemplateProps.Jsii$Proxy that = (CfnConfigurationTemplateProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentId != null ? !this.environmentId.equals(that.environmentId) : that.environmentId != null) return false;
            if (this.optionSettings != null ? !this.optionSettings.equals(that.optionSettings) : that.optionSettings != null) return false;
            if (this.platformArn != null ? !this.platformArn.equals(that.platformArn) : that.platformArn != null) return false;
            if (this.solutionStackName != null ? !this.solutionStackName.equals(that.solutionStackName) : that.solutionStackName != null) return false;
            return this.sourceConfiguration != null ? this.sourceConfiguration.equals(that.sourceConfiguration) : that.sourceConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentId != null ? this.environmentId.hashCode() : 0);
            result = 31 * result + (this.optionSettings != null ? this.optionSettings.hashCode() : 0);
            result = 31 * result + (this.platformArn != null ? this.platformArn.hashCode() : 0);
            result = 31 * result + (this.solutionStackName != null ? this.solutionStackName.hashCode() : 0);
            result = 31 * result + (this.sourceConfiguration != null ? this.sourceConfiguration.hashCode() : 0);
            return result;
        }
    }
}
