package software.amazon.awscdk.services.events;

/**
 * (experimental) An API Destination Connection.
 * <p>
 * A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:01.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_events.ConnectionProps")
@software.amazon.jsii.Jsii.Proxy(ConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ConnectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The authorization type for the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Authorization getAuthorization();

    /**
     * (experimental) Additional string parameters to add to the invocation bodies.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getBodyParameters() {
        return null;
    }

    /**
     * (experimental) The name of the connection.
     * <p>
     * Default: - A name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionName() {
        return null;
    }

    /**
     * (experimental) The name of the connection.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Additional string parameters to add to the invocation headers.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getHeaderParameters() {
        return null;
    }

    /**
     * (experimental) Additional string parameters to add to the invocation query strings.
     * <p>
     * Default: - No additional parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getQueryStringParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionProps> {
        software.amazon.awscdk.services.events.Authorization authorization;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> bodyParameters;
        java.lang.String connectionName;
        java.lang.String description;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> headerParameters;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> queryStringParameters;

        /**
         * Sets the value of {@link ConnectionProps#getAuthorization}
         * @param authorization The authorization type for the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authorization(software.amazon.awscdk.services.events.Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getBodyParameters}
         * @param bodyParameters Additional string parameters to add to the invocation bodies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder bodyParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> bodyParameters) {
            this.bodyParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)bodyParameters;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getConnectionName}
         * @param connectionName The name of the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionName(java.lang.String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getDescription}
         * @param description The name of the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getHeaderParameters}
         * @param headerParameters Additional string parameters to add to the invocation headers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder headerParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> headerParameters) {
            this.headerParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)headerParameters;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getQueryStringParameters}
         * @param queryStringParameters Additional string parameters to add to the invocation query strings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder queryStringParameters(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.events.HttpParameter> queryStringParameters) {
            this.queryStringParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)queryStringParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionProps {
        private final software.amazon.awscdk.services.events.Authorization authorization;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> bodyParameters;
        private final java.lang.String connectionName;
        private final java.lang.String description;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> headerParameters;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> queryStringParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorization = software.amazon.jsii.Kernel.get(this, "authorization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Authorization.class));
            this.bodyParameters = software.amazon.jsii.Kernel.get(this, "bodyParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
            this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.headerParameters = software.amazon.jsii.Kernel.get(this, "headerParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
            this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.HttpParameter.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorization = java.util.Objects.requireNonNull(builder.authorization, "authorization is required");
            this.bodyParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.bodyParameters;
            this.connectionName = builder.connectionName;
            this.description = builder.description;
            this.headerParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.headerParameters;
            this.queryStringParameters = (java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter>)builder.queryStringParameters;
        }

        @Override
        public final software.amazon.awscdk.services.events.Authorization getAuthorization() {
            return this.authorization;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getBodyParameters() {
            return this.bodyParameters;
        }

        @Override
        public final java.lang.String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getHeaderParameters() {
            return this.headerParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.events.HttpParameter> getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorization", om.valueToTree(this.getAuthorization()));
            if (this.getBodyParameters() != null) {
                data.set("bodyParameters", om.valueToTree(this.getBodyParameters()));
            }
            if (this.getConnectionName() != null) {
                data.set("connectionName", om.valueToTree(this.getConnectionName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getHeaderParameters() != null) {
                data.set("headerParameters", om.valueToTree(this.getHeaderParameters()));
            }
            if (this.getQueryStringParameters() != null) {
                data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_events.ConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionProps.Jsii$Proxy that = (ConnectionProps.Jsii$Proxy) o;

            if (!authorization.equals(that.authorization)) return false;
            if (this.bodyParameters != null ? !this.bodyParameters.equals(that.bodyParameters) : that.bodyParameters != null) return false;
            if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.headerParameters != null ? !this.headerParameters.equals(that.headerParameters) : that.headerParameters != null) return false;
            return this.queryStringParameters != null ? this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorization.hashCode();
            result = 31 * result + (this.bodyParameters != null ? this.bodyParameters.hashCode() : 0);
            result = 31 * result + (this.connectionName != null ? this.connectionName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.headerParameters != null ? this.headerParameters.hashCode() : 0);
            result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
            return result;
        }
    }
}
