package software.amazon.awscdk.services.events;

/**
 * (experimental) Schedule for scheduled event rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:01.471Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_events.Schedule")
public abstract class Schedule extends software.amazon.jsii.JsiiObject {

    protected Schedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected Schedule() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Create a schedule from a set of cron fields.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Schedule cron(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.CronOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Schedule.class, "cron", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Construct a schedule from a literal schedule expression.
     * <p>
     * @param expression The expression to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Schedule expression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Schedule.class, "expression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * (experimental) Construct a schedule from an interval and a time unit.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Schedule rate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Schedule.class, "rate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Schedule.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * (experimental) Retrieve the expression for this schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getExpressionString();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.events.Schedule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) Retrieve the expression for this schedule.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getExpressionString() {
            return software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
