package software.amazon.awscdk.services.events.targets;

/**
 * (experimental) Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Repository repo;
 * PipelineProject project;
 * Topic myTopic;
 * // starts a CodeBuild project when a commit is pushed to the "master" branch of the repo
 * repo.onCommit("CommitToMaster", OnCommitOptions.builder()
 *         .target(new CodeBuildProject(project))
 *         .branches(List.of("master"))
 *         .build());
 * // publishes a message to an Amazon SNS topic when a comment is made on a pull request
 * Rule rule = repo.onCommentOnPullRequest("CommentOnPullRequest", OnEventOptions.builder()
 *         .target(new SnsTopic(myTopic))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:01.502Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_events_targets.CodeBuildProject")
public class CodeBuildProject extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected CodeBuildProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeBuildProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CodeBuildProject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject project, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.CodeBuildProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), props });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public CodeBuildProject(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * (experimental) Allows using build projects as event rule targets.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * (experimental) Allows using build projects as event rule targets.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.events.targets.CodeBuildProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.CodeBuildProject> {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.codebuild.IProject project) {
            return new Builder(project);
        }

        private final software.amazon.awscdk.services.codebuild.IProject project;
        private software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder props;

        private Builder(final software.amazon.awscdk.services.codebuild.IProject project) {
            this.project = project;
        }

        /**
         * (experimental) The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * (experimental) The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxEventAge(final software.amazon.awscdk.core.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * (experimental) The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) The event to send to CodeBuild.
         * <p>
         * This will be the payload for the StartBuild API.
         * <p>
         * Default: - the entire EventBridge event
         * <p>
         * @return {@code this}
         * @param event The event to send to CodeBuild. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder event(final software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        /**
         * (experimental) The role to assume before invoking the target (i.e., the codebuild) when the given rule is triggered.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the codebuild) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.props().eventRole(eventRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.CodeBuildProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.events.targets.CodeBuildProject build() {
            return new software.amazon.awscdk.services.events.targets.CodeBuildProject(
                this.project,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder();
            }
            return this.props;
        }
    }
}
