/**
 * <h1>Amazon FSx Construct Library</h1>
 * <p>
 * <a href="https://docs.aws.amazon.com/fsx/?id=docs_gateway">Amazon FSx</a> provides fully managed third-party file systems with the
 * native compatibility and feature sets for workloads such as Microsoft Windows–based storage, high-performance computing,
 * machine learning, and electronic design automation.
 * <p>
 * Amazon FSx supports two file system types: <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/index.html">Lustre</a> and
 * <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/index.html">Windows</a> File Server.
 * <p>
 * <h2>FSx for Lustre</h2>
 * <p>
 * Amazon FSx for Lustre makes it easy and cost-effective to launch and run the popular, high-performance Lustre file
 * system. You use Lustre for workloads where speed matters, such as machine learning, high performance computing (HPC),
 * video processing, and financial modeling.
 * <p>
 * The open-source Lustre file system is designed for applications that require fast storage—where you want your storage
 * to keep up with your compute. Lustre was built to solve the problem of quickly and cheaply processing the world's
 * ever-growing datasets. It's a widely used file system designed for the fastest computers in the world. It provides
 * submillisecond latencies, up to hundreds of GBps of throughput, and up to millions of IOPS. For more information on
 * Lustre, see the <a href="http://lustre.org/">Lustre website</a>.
 * <p>
 * As a fully managed service, Amazon FSx makes it easier for you to use Lustre for workloads where storage speed matters.
 * Amazon FSx for Lustre eliminates the traditional complexity of setting up and managing Lustre file systems, enabling
 * you to spin up and run a battle-tested high-performance file system in minutes. It also provides multiple deployment
 * options so you can optimize cost for your needs.
 * <p>
 * Amazon FSx for Lustre is POSIX-compliant, so you can use your current Linux-based applications without having to make
 * any changes. Amazon FSx for Lustre provides a native file system interface and works as any file system does with your
 * Linux operating system. It also provides read-after-write consistency and supports file locking.
 * <p>
 * <h3>Installation</h3>
 * <p>
 * Import to your project:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * </pre></blockquote>
 * <p>
 * <h3>Basic Usage</h3>
 * <p>
 * Setup required properties and create:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * 
 * 
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.SCRATCH_2).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Connecting</h3>
 * <p>
 * To control who can access the file system, use the <code>.connections</code> attribute. FSx has a fixed default port, so you don't
 * need to specify the port. This example allows an EC2 instance to connect to a file system:
 * <p>
 * <blockquote><pre>
 * LustreFileSystem fileSystem;
 * Instance instance;
 * 
 * 
 * fileSystem.connections.allowDefaultPortFrom(instance);
 * </pre></blockquote>
 * <p>
 * <h3>Mounting</h3>
 * <p>
 * The LustreFileSystem Construct exposes both the DNS name of the file system as well as its mount name, which can be
 * used to mount the file system on an EC2 instance. The following example shows how to bring up a file system and EC2
 * instance, and then use User Data to mount the file system on the instance at start-up:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * 
 * Vpc vpc;
 * 
 * Map&lt;String, LustreDeploymentType&gt; lustreConfiguration = Map.of(
 *         "deploymentType", LustreDeploymentType.SCRATCH_2);
 * 
 * LustreFileSystem fs = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(lustreConfiguration)
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .build();
 * 
 * Instance inst = Instance.Builder.create(this, "inst")
 *         .instanceType(InstanceType.of(InstanceClass.T2, InstanceSize.LARGE))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .build();
 * fs.connections.allowDefaultPortFrom(inst);
 * 
 * // Need to give the instance access to read information about FSx to determine the file system's mount name.
 * inst.role.addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName("AmazonFSxReadOnlyAccess"));
 * 
 * String mountPath = "/mnt/fsx";
 * String dnsName = fs.getDnsName();
 * String mountName = fs.getMountName();
 * 
 * inst.userData.addCommands("set -eux", "yum update -y", "amazon-linux-extras install -y lustre2.10", String.format("mkdir -p %s", mountPath), String.format("chmod 777 %s", mountPath), String.format("chown ec2-user:ec2-user %s", mountPath), String.format("echo \"%s&#64;tcp:/%s %s lustre defaults,noatime,flock,_netdev 0 0\" &gt;&gt; /etc/fstab", dnsName, mountName, mountPath), "mount -a");
 * </pre></blockquote>
 * <p>
 * <h3>Importing</h3>
 * <p>
 * An FSx for Lustre file system can be imported with <code>fromLustreFileSystemAttributes(stack, id, attributes)</code>. The
 * following example lays out how you could import the SecurityGroup a file system belongs to, use that to import the file
 * system, and then also import the VPC the file system is in and add an EC2 instance to it, giving it access to the file
 * system.
 * <p>
 * <blockquote><pre>
 * ISecurityGroup sg = SecurityGroup.fromSecurityGroupId(this, "FsxSecurityGroup", "{SECURITY-GROUP-ID}");
 * IFileSystem fs = LustreFileSystem.fromLustreFileSystemAttributes(this, "FsxLustreFileSystem", FileSystemAttributes.builder()
 *         .dnsName("{FILE-SYSTEM-DNS-NAME}")
 *         .fileSystemId("{FILE-SYSTEM-ID}")
 *         .securityGroup(sg)
 *         .build());
 * 
 * IVpc vpc = Vpc.fromVpcAttributes(this, "Vpc", VpcAttributes.builder()
 *         .availabilityZones(List.of("us-west-2a", "us-west-2b"))
 *         .publicSubnetIds(List.of("{US-WEST-2A-SUBNET-ID}", "{US-WEST-2B-SUBNET-ID}"))
 *         .vpcId("{VPC-ID}")
 *         .build());
 * 
 * Instance inst = Instance.Builder.create(this, "inst")
 *         .instanceType(InstanceType.of(InstanceClass.T2, InstanceSize.LARGE))
 *         .machineImage(AmazonLinuxImage.Builder.create()
 *                 .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                 .build())
 *         .vpc(vpc)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .build();
 * 
 * fs.connections.allowDefaultPortFrom(inst);
 * </pre></blockquote>
 * <p>
 * <h2>FSx for Windows File Server</h2>
 * <p>
 * The L2 construct for the FSx for Windows File Server has not yet been implemented. To instantiate an FSx for Windows
 * file system, the L1 constructs can be used as defined by CloudFormation.
 */
package software.amazon.awscdk.services.fsx;
