package software.amazon.awscdk.services.glue;

/**
 * (experimental) AWS Glue version determines the versions of Apache Spark and Python that are available to the job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "PythonShellJob")
 *         .executable(JobExecutable.pythonShell(PythonShellExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V1_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromBucket(bucket, "script.py"))
 *                 .build()))
 *         .description("an example Python Shell job")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html.
 * If you need to use a GlueVersion that doesn't exist as a static member, you
 * can instantiate a `GlueVersion` object, e.g: `GlueVersion.of('1.5')`.">https://docs.aws.amazon.com/glue/latest/dg/add-job.html.
 * If you need to use a GlueVersion that doesn't exist as a static member, you
 * can instantiate a `GlueVersion` object, e.g: `GlueVersion.of('1.5')`.</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.252Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.GlueVersion")
public class GlueVersion extends software.amazon.jsii.JsiiObject {

    protected GlueVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GlueVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        V0_9 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.GlueVersion.class, "V0_9", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class));
        V1_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.GlueVersion.class, "V1_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class));
        V2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.GlueVersion.class, "V2_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class));
        V3_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.GlueVersion.class, "V3_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class));
    }

    /**
     * (experimental) Custom Glue version.
     * <p>
     * @param version custom version. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.GlueVersion of(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.GlueVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class), new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * (experimental) Glue version using Spark 2.2.1 and Python 2.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.GlueVersion V0_9;

    /**
     * (experimental) Glue version using Spark 2.4.3, Python 2.7 and Python 3.6.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.GlueVersion V1_0;

    /**
     * (experimental) Glue version using Spark 2.4.3 and Python 3.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.GlueVersion V2_0;

    /**
     * (experimental) Glue version using Spark 3.1.1 and Python 3.7.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.GlueVersion V3_0;

    /**
     * (experimental) The name of this GlueVersion, as expected by Job resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
