package software.amazon.awscdk.services.glue;

/**
 * (experimental) The executable properties related to the Glue job's GlueVersion, JobType and code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "PythonShellJob")
 *         .executable(JobExecutable.pythonShell(PythonShellExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V1_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromBucket(bucket, "script.py"))
 *                 .build()))
 *         .description("an example Python Shell job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.JobExecutable")
public class JobExecutable extends software.amazon.jsii.JsiiObject {

    protected JobExecutable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobExecutable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a custom JobExecutable.
     * <p>
     * @param config custom job executable configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutableConfig config) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * (experimental) Create Python executable props for Apache Spark ETL job.
     * <p>
     * @param props Python Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable pythonEtl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.PythonSparkJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "pythonEtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Python executable props for python shell jobs.
     * <p>
     * @param props Python Shell Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable pythonShell(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.PythonShellExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "pythonShell", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Python executable props for Apache Spark Streaming job.
     * <p>
     * @param props Python Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable pythonStreaming(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.PythonSparkJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "pythonStreaming", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Scala executable props for Apache Spark ETL job.
     * <p>
     * @param props Scala Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable scalaEtl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.ScalaJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "scalaEtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Scala executable props for Apache Spark Streaming job.
     * <p>
     * @param props Scala Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable scalaStreaming(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.ScalaJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.JobExecutable.class, "scalaStreaming", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called during Job initialization to get JobExecutableConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutableConfig bind() {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutableConfig.class));
    }
}
