package software.amazon.awscdk.services.glue;

/**
 * (experimental) Construction properties for {@link Job}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "PythonShellJob")
 *         .executable(JobExecutable.pythonShell(PythonShellExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V1_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromBucket(bucket, "script.py"))
 *                 .build()))
 *         .description("an example Python Shell job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.266Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.JobProps")
@software.amazon.jsii.Jsii.Proxy(JobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The job's executable properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.JobExecutable getExecutable();

    /**
     * (experimental) The {@link Connection}s used for this job.
     * <p>
     * Connections are used to connect to other AWS Service or resources within a VPC.
     * <p>
     * Default: [] - no connections are added to the job
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.IConnection> getConnections() {
        return null;
    }

    /**
     * (experimental) Enables continuous logging with the specified props.
     * <p>
     * Default: - continuous logging is disabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.ContinuousLoggingProps getContinuousLogging() {
        return null;
    }

    /**
     * (experimental) The default arguments for this job, specified as name-value pairs.
     * <p>
     * Default: - no arguments
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html for a list of reserved parameters">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html for a list of reserved parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getDefaultArguments() {
        return null;
    }

    /**
     * (experimental) The description of the job.
     * <p>
     * Default: - no value
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) Enables the collection of metrics for job profiling.
     * <p>
     * Default: - no profiling metrics emitted.
     * <p>
     * @see <a href="`--enable-metrics` at https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">`--enable-metrics` at https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableProfilingMetrics() {
        return null;
    }

    /**
     * (experimental) The name of the job.
     * <p>
     * Default: - a name is automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getJobName() {
        return null;
    }

    /**
     * (experimental) The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
     * <p>
     * Cannot be used for Glue version 2.0 and later - workerType and workerCount should be used instead.
     * <p>
     * Default: - 10 when job type is Apache Spark ETL or streaming, 0.0625 when job type is Python shell
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * (experimental) The maximum number of concurrent runs allowed for the job.
     * <p>
     * An error is returned when this threshold is reached. The maximum value you can specify is controlled by a service limit.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentRuns() {
        return null;
    }

    /**
     * (experimental) The maximum number of times to retry this job after a job run fails.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * (experimental) The number of minutes to wait after a job run starts, before sending a job run delay notification.
     * <p>
     * Default: - no delay notifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getNotifyDelayAfter() {
        return null;
    }

    /**
     * (experimental) The IAM role assumed by Glue to run this job.
     * <p>
     * If providing a custom role, it needs to trust the Glue service principal (glue.amazonaws.com) and be granted sufficient permissions.
     * <p>
     * Default: - a role is automatically generated
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/getting-started-access.html">https://docs.aws.amazon.com/glue/latest/dg/getting-started-access.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) The {@link SecurityConfiguration} to use for this job.
     * <p>
     * Default: - no security configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.ISecurityConfiguration getSecurityConfiguration() {
        return null;
    }

    /**
     * (experimental) Enables the Spark UI debugging and monitoring with the specified props.
     * <p>
     * Default: - Spark UI debugging and monitoring is disabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.SparkUIProps getSparkUI() {
        return null;
    }

    /**
     * (experimental) The tags to add to the resources on which the job runs.
     * <p>
     * Default: {} - no tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * (experimental) The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
     * <p>
     * Default: cdk.Duration.hours(48)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * (experimental) The number of workers of a defined {@link WorkerType} that are allocated when a job runs.
     * <p>
     * Default: - differs based on specific Glue version/worker type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWorkerCount() {
        return null;
    }

    /**
     * (experimental) The type of predefined worker that is allocated when a job runs.
     * <p>
     * Default: - differs based on specific Glue version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.WorkerType getWorkerType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobProps> {
        software.amazon.awscdk.services.glue.JobExecutable executable;
        java.util.List<software.amazon.awscdk.services.glue.IConnection> connections;
        software.amazon.awscdk.services.glue.ContinuousLoggingProps continuousLogging;
        java.util.Map<java.lang.String, java.lang.String> defaultArguments;
        java.lang.String description;
        java.lang.Boolean enableProfilingMetrics;
        java.lang.String jobName;
        java.lang.Number maxCapacity;
        java.lang.Number maxConcurrentRuns;
        java.lang.Number maxRetries;
        software.amazon.awscdk.core.Duration notifyDelayAfter;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.glue.ISecurityConfiguration securityConfiguration;
        software.amazon.awscdk.services.glue.SparkUIProps sparkUi;
        java.util.Map<java.lang.String, java.lang.String> tags;
        software.amazon.awscdk.core.Duration timeout;
        java.lang.Number workerCount;
        software.amazon.awscdk.services.glue.WorkerType workerType;

        /**
         * Sets the value of {@link JobProps#getExecutable}
         * @param executable The job's executable properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executable(software.amazon.awscdk.services.glue.JobExecutable executable) {
            this.executable = executable;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getConnections}
         * @param connections The {@link Connection}s used for this job.
         *                    Connections are used to connect to other AWS Service or resources within a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder connections(java.util.List<? extends software.amazon.awscdk.services.glue.IConnection> connections) {
            this.connections = (java.util.List<software.amazon.awscdk.services.glue.IConnection>)connections;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getContinuousLogging}
         * @param continuousLogging Enables continuous logging with the specified props.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder continuousLogging(software.amazon.awscdk.services.glue.ContinuousLoggingProps continuousLogging) {
            this.continuousLogging = continuousLogging;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getDefaultArguments}
         * @param defaultArguments The default arguments for this job, specified as name-value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultArguments(java.util.Map<java.lang.String, java.lang.String> defaultArguments) {
            this.defaultArguments = defaultArguments;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getDescription}
         * @param description The description of the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getEnableProfilingMetrics}
         * @param enableProfilingMetrics Enables the collection of metrics for job profiling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableProfilingMetrics(java.lang.Boolean enableProfilingMetrics) {
            this.enableProfilingMetrics = enableProfilingMetrics;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getJobName}
         * @param jobName The name of the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobName(java.lang.String jobName) {
            this.jobName = jobName;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getMaxCapacity}
         * @param maxCapacity The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
         *                    Cannot be used for Glue version 2.0 and later - workerType and workerCount should be used instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getMaxConcurrentRuns}
         * @param maxConcurrentRuns The maximum number of concurrent runs allowed for the job.
         *                          An error is returned when this threshold is reached. The maximum value you can specify is controlled by a service limit.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxConcurrentRuns(java.lang.Number maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getMaxRetries}
         * @param maxRetries The maximum number of times to retry this job after a job run fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getNotifyDelayAfter}
         * @param notifyDelayAfter The number of minutes to wait after a job run starts, before sending a job run delay notification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notifyDelayAfter(software.amazon.awscdk.core.Duration notifyDelayAfter) {
            this.notifyDelayAfter = notifyDelayAfter;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getRole}
         * @param role The IAM role assumed by Glue to run this job.
         *             If providing a custom role, it needs to trust the Glue service principal (glue.amazonaws.com) and be granted sufficient permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getSecurityConfiguration}
         * @param securityConfiguration The {@link SecurityConfiguration} to use for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfiguration(software.amazon.awscdk.services.glue.ISecurityConfiguration securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getSparkUi}
         * @param sparkUi Enables the Spark UI debugging and monitoring with the specified props.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sparkUi(software.amazon.awscdk.services.glue.SparkUIProps sparkUi) {
            this.sparkUi = sparkUi;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getTags}
         * @param tags The tags to add to the resources on which the job runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getTimeout}
         * @param timeout The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getWorkerCount}
         * @param workerCount The number of workers of a defined {@link WorkerType} that are allocated when a job runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workerCount(java.lang.Number workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        /**
         * Sets the value of {@link JobProps#getWorkerType}
         * @param workerType The type of predefined worker that is allocated when a job runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workerType(software.amazon.awscdk.services.glue.WorkerType workerType) {
            this.workerType = workerType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobProps {
        private final software.amazon.awscdk.services.glue.JobExecutable executable;
        private final java.util.List<software.amazon.awscdk.services.glue.IConnection> connections;
        private final software.amazon.awscdk.services.glue.ContinuousLoggingProps continuousLogging;
        private final java.util.Map<java.lang.String, java.lang.String> defaultArguments;
        private final java.lang.String description;
        private final java.lang.Boolean enableProfilingMetrics;
        private final java.lang.String jobName;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number maxConcurrentRuns;
        private final java.lang.Number maxRetries;
        private final software.amazon.awscdk.core.Duration notifyDelayAfter;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.glue.ISecurityConfiguration securityConfiguration;
        private final software.amazon.awscdk.services.glue.SparkUIProps sparkUi;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final software.amazon.awscdk.core.Duration timeout;
        private final java.lang.Number workerCount;
        private final software.amazon.awscdk.services.glue.WorkerType workerType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobExecutable.class));
            this.connections = software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.IConnection.class)));
            this.continuousLogging = software.amazon.jsii.Kernel.get(this, "continuousLogging", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ContinuousLoggingProps.class));
            this.defaultArguments = software.amazon.jsii.Kernel.get(this, "defaultArguments", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableProfilingMetrics = software.amazon.jsii.Kernel.get(this, "enableProfilingMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxConcurrentRuns = software.amazon.jsii.Kernel.get(this, "maxConcurrentRuns", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.notifyDelayAfter = software.amazon.jsii.Kernel.get(this, "notifyDelayAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityConfiguration = software.amazon.jsii.Kernel.get(this, "securityConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ISecurityConfiguration.class));
            this.sparkUi = software.amazon.jsii.Kernel.get(this, "sparkUI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.SparkUIProps.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.workerCount = software.amazon.jsii.Kernel.get(this, "workerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.workerType = software.amazon.jsii.Kernel.get(this, "workerType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.WorkerType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executable = java.util.Objects.requireNonNull(builder.executable, "executable is required");
            this.connections = (java.util.List<software.amazon.awscdk.services.glue.IConnection>)builder.connections;
            this.continuousLogging = builder.continuousLogging;
            this.defaultArguments = builder.defaultArguments;
            this.description = builder.description;
            this.enableProfilingMetrics = builder.enableProfilingMetrics;
            this.jobName = builder.jobName;
            this.maxCapacity = builder.maxCapacity;
            this.maxConcurrentRuns = builder.maxConcurrentRuns;
            this.maxRetries = builder.maxRetries;
            this.notifyDelayAfter = builder.notifyDelayAfter;
            this.role = builder.role;
            this.securityConfiguration = builder.securityConfiguration;
            this.sparkUi = builder.sparkUi;
            this.tags = builder.tags;
            this.timeout = builder.timeout;
            this.workerCount = builder.workerCount;
            this.workerType = builder.workerType;
        }

        @Override
        public final software.amazon.awscdk.services.glue.JobExecutable getExecutable() {
            return this.executable;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.IConnection> getConnections() {
            return this.connections;
        }

        @Override
        public final software.amazon.awscdk.services.glue.ContinuousLoggingProps getContinuousLogging() {
            return this.continuousLogging;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getDefaultArguments() {
            return this.defaultArguments;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnableProfilingMetrics() {
            return this.enableProfilingMetrics;
        }

        @Override
        public final java.lang.String getJobName() {
            return this.jobName;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMaxConcurrentRuns() {
            return this.maxConcurrentRuns;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getNotifyDelayAfter() {
            return this.notifyDelayAfter;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.glue.ISecurityConfiguration getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.glue.SparkUIProps getSparkUI() {
            return this.sparkUi;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Number getWorkerCount() {
            return this.workerCount;
        }

        @Override
        public final software.amazon.awscdk.services.glue.WorkerType getWorkerType() {
            return this.workerType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executable", om.valueToTree(this.getExecutable()));
            if (this.getConnections() != null) {
                data.set("connections", om.valueToTree(this.getConnections()));
            }
            if (this.getContinuousLogging() != null) {
                data.set("continuousLogging", om.valueToTree(this.getContinuousLogging()));
            }
            if (this.getDefaultArguments() != null) {
                data.set("defaultArguments", om.valueToTree(this.getDefaultArguments()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnableProfilingMetrics() != null) {
                data.set("enableProfilingMetrics", om.valueToTree(this.getEnableProfilingMetrics()));
            }
            if (this.getJobName() != null) {
                data.set("jobName", om.valueToTree(this.getJobName()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxConcurrentRuns() != null) {
                data.set("maxConcurrentRuns", om.valueToTree(this.getMaxConcurrentRuns()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }
            if (this.getNotifyDelayAfter() != null) {
                data.set("notifyDelayAfter", om.valueToTree(this.getNotifyDelayAfter()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityConfiguration() != null) {
                data.set("securityConfiguration", om.valueToTree(this.getSecurityConfiguration()));
            }
            if (this.getSparkUI() != null) {
                data.set("sparkUI", om.valueToTree(this.getSparkUI()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getWorkerCount() != null) {
                data.set("workerCount", om.valueToTree(this.getWorkerCount()));
            }
            if (this.getWorkerType() != null) {
                data.set("workerType", om.valueToTree(this.getWorkerType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_glue.JobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobProps.Jsii$Proxy that = (JobProps.Jsii$Proxy) o;

            if (!executable.equals(that.executable)) return false;
            if (this.connections != null ? !this.connections.equals(that.connections) : that.connections != null) return false;
            if (this.continuousLogging != null ? !this.continuousLogging.equals(that.continuousLogging) : that.continuousLogging != null) return false;
            if (this.defaultArguments != null ? !this.defaultArguments.equals(that.defaultArguments) : that.defaultArguments != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enableProfilingMetrics != null ? !this.enableProfilingMetrics.equals(that.enableProfilingMetrics) : that.enableProfilingMetrics != null) return false;
            if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxConcurrentRuns != null ? !this.maxConcurrentRuns.equals(that.maxConcurrentRuns) : that.maxConcurrentRuns != null) return false;
            if (this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null) return false;
            if (this.notifyDelayAfter != null ? !this.notifyDelayAfter.equals(that.notifyDelayAfter) : that.notifyDelayAfter != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityConfiguration != null ? !this.securityConfiguration.equals(that.securityConfiguration) : that.securityConfiguration != null) return false;
            if (this.sparkUi != null ? !this.sparkUi.equals(that.sparkUi) : that.sparkUi != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.workerCount != null ? !this.workerCount.equals(that.workerCount) : that.workerCount != null) return false;
            return this.workerType != null ? this.workerType.equals(that.workerType) : that.workerType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executable.hashCode();
            result = 31 * result + (this.connections != null ? this.connections.hashCode() : 0);
            result = 31 * result + (this.continuousLogging != null ? this.continuousLogging.hashCode() : 0);
            result = 31 * result + (this.defaultArguments != null ? this.defaultArguments.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enableProfilingMetrics != null ? this.enableProfilingMetrics.hashCode() : 0);
            result = 31 * result + (this.jobName != null ? this.jobName.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxConcurrentRuns != null ? this.maxConcurrentRuns.hashCode() : 0);
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            result = 31 * result + (this.notifyDelayAfter != null ? this.notifyDelayAfter.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityConfiguration != null ? this.securityConfiguration.hashCode() : 0);
            result = 31 * result + (this.sparkUi != null ? this.sparkUi.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.workerCount != null ? this.workerCount.hashCode() : 0);
            result = 31 * result + (this.workerType != null ? this.workerType.hashCode() : 0);
            return result;
        }
    }
}
