package software.amazon.awscdk.services.glue;

/**
 * (experimental) Properties of a Partition Index.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table myTable;
 * myTable.addPartitionIndex(PartitionIndex.builder()
 *         .indexName("my-index")
 *         .keyNames(List.of("year"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.PartitionIndex")
@software.amazon.jsii.Jsii.Proxy(PartitionIndex.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PartitionIndex extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The partition key names that comprise the partition index.
     * <p>
     * The names must correspond to a name in the
     * table's partition keys.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getKeyNames();

    /**
     * (experimental) The name of the partition index.
     * <p>
     * Default: - a name will be generated for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getIndexName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PartitionIndex}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PartitionIndex}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PartitionIndex> {
        java.util.List<java.lang.String> keyNames;
        java.lang.String indexName;

        /**
         * Sets the value of {@link PartitionIndex#getKeyNames}
         * @param keyNames The partition key names that comprise the partition index. This parameter is required.
         *                 The names must correspond to a name in the
         *                 table's partition keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder keyNames(java.util.List<java.lang.String> keyNames) {
            this.keyNames = keyNames;
            return this;
        }

        /**
         * Sets the value of {@link PartitionIndex#getIndexName}
         * @param indexName The name of the partition index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PartitionIndex}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PartitionIndex build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PartitionIndex}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PartitionIndex {
        private final java.util.List<java.lang.String> keyNames;
        private final java.lang.String indexName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyNames = software.amazon.jsii.Kernel.get(this, "keyNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyNames = java.util.Objects.requireNonNull(builder.keyNames, "keyNames is required");
            this.indexName = builder.indexName;
        }

        @Override
        public final java.util.List<java.lang.String> getKeyNames() {
            return this.keyNames;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyNames", om.valueToTree(this.getKeyNames()));
            if (this.getIndexName() != null) {
                data.set("indexName", om.valueToTree(this.getIndexName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_glue.PartitionIndex"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PartitionIndex.Jsii$Proxy that = (PartitionIndex.Jsii$Proxy) o;

            if (!keyNames.equals(that.keyNames)) return false;
            return this.indexName != null ? this.indexName.equals(that.indexName) : that.indexName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyNames.hashCode();
            result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
            return result;
        }
    }
}
