package software.amazon.awscdk.services.glue;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * Table.Builder.create(this, "MyTable")
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .partitionKeys(List.of(Column.builder()
 *                 .name("year")
 *                 .type(Schema.SMALL_INT)
 *                 .build(), Column.builder()
 *                 .name("month")
 *                 .type(Schema.SMALL_INT)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/data-types.html">https://docs.aws.amazon.com/athena/latest/ug/data-types.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.279Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.Schema")
public class Schema extends software.amazon.jsii.JsiiObject {

    protected Schema(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schema(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        BIG_INT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "BIG_INT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        BINARY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "BINARY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        BOOLEAN = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "BOOLEAN", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        DATE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "DATE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        DOUBLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "DOUBLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        FLOAT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "FLOAT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        INTEGER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "INTEGER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        SMALL_INT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "SMALL_INT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        STRING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "STRING", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        TIMESTAMP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "TIMESTAMP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
        TINY_INT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.Schema.class, "TINY_INT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Schema() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Creates an array of some other type.
     * <p>
     * @param itemType type contained by the array. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type array(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type itemType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "array", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(itemType, "itemType is required") });
    }

    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     * <p>
     * @param length length between 1 and 255. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type doChar(final @org.jetbrains.annotations.NotNull java.lang.Number length) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "char", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(length, "length is required") });
    }

    /**
     * (experimental) Creates a decimal type.
     * <p>
     * TODO: Bounds
     * <p>
     * @param precision the total number of digits. This parameter is required.
     * @param scale the number of digits in fractional part, the default is 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type decimal(final @org.jetbrains.annotations.NotNull java.lang.Number precision, final @org.jetbrains.annotations.Nullable java.lang.Number scale) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "decimal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(precision, "precision is required"), scale });
    }

    /**
     * (experimental) Creates a decimal type.
     * <p>
     * TODO: Bounds
     * <p>
     * @param precision the total number of digits. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type decimal(final @org.jetbrains.annotations.NotNull java.lang.Number precision) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "decimal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(precision, "precision is required") });
    }

    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     * <p>
     * @param keyType type of key, must be a primitive. This parameter is required.
     * @param valueType type fo the value indexed by the key. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type map(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type keyType, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type valueType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "map", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(keyType, "keyType is required"), java.util.Objects.requireNonNull(valueType, "valueType is required") });
    }

    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     * <p>
     * @param columns the columns of the structure. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type struct(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.glue.Column> columns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "struct", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(columns, "columns is required") });
    }

    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     * <p>
     * @param length length between 1 and 65535. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Type varchar(final @org.jetbrains.annotations.NotNull java.lang.Number length) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.Schema.class, "varchar", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Type.class), new Object[] { java.util.Objects.requireNonNull(length, "length is required") });
    }

    /**
     * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type BIG_INT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type BINARY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type BOOLEAN;

    /**
     * (experimental) Date type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type DATE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type DOUBLE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type FLOAT;

    /**
     * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type INTEGER;

    /**
     * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type SMALL_INT;

    /**
     * (experimental) Arbitrary-length string type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type STRING;

    /**
     * (experimental) Timestamp type (date and time).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type TIMESTAMP;

    /**
     * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.Type TINY_INT;
}
