package software.amazon.awscdk.services.glue;

/**
 * (experimental) Encryption options for a Table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * Table.Builder.create(this, "MyTable")
 *         .encryption(TableEncryption.S3_MANAGED)
 *         // ...
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/encryption.html">https://docs.aws.amazon.com/athena/latest/ug/encryption.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.289Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.TableEncryption")
public enum TableEncryption {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    UNENCRYPTED,
    /**
     * (experimental) Server side encryption (SSE) with an Amazon S3-managed key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    S3_MANAGED,
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KMS,
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the KMS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    KMS_MANAGED,
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CLIENT_SIDE_KMS,
}
