package software.amazon.awscdk.services.glue;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * Table.Builder.create(this, "MyTable")
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .partitionKeys(List.of(Column.builder()
 *                 .name("year")
 *                 .type(Schema.SMALL_INT)
 *                 .build(), Column.builder()
 *                 .name("month")
 *                 .type(Schema.SMALL_INT)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.290Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_glue.TableProps")
@software.amazon.jsii.Jsii.Proxy(TableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Columns of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.glue.Column> getColumns();

    /**
     * (experimental) Database in which to store the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.IDatabase getDatabase();

    /**
     * (experimental) Storage type of the table's data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.DataFormat getDataFormat();

    /**
     * (experimental) Name of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * (experimental) S3 bucket in which to store data.
     * <p>
     * Default: one is created for you
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return null;
    }

    /**
     * (experimental) Indicates whether the table's data is compressed or not.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompressed() {
        return null;
    }

    /**
     * (experimental) Description of the table.
     * <p>
     * Default: generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The kind of encryption to secure the data with.
     * <p>
     * You can only provide this option if you are not explicitly passing in a bucket.
     * <p>
     * If you choose <code>SSE-KMS</code>, you <em>can</em> provide an un-managed KMS key with <code>encryptionKey</code>.
     * If you choose <code>CSE-KMS</code>, you <em>must</em> provide an un-managed KMS key with <code>encryptionKey</code>.
     * <p>
     * Default: Unencrypted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.TableEncryption getEncryption() {
        return null;
    }

    /**
     * (experimental) External KMS key to use for bucket encryption.
     * <p>
     * The <code>encryption</code> property must be <code>SSE-KMS</code> or <code>CSE-KMS</code>.
     * <p>
     * Default: key is managed by KMS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) Partition indexes on the table.
     * <p>
     * A maximum of 3 indexes
     * are allowed on a table. Keys in the index must be part
     * of the table's partition keys.
     * <p>
     * Default: table has no partition indexes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.PartitionIndex> getPartitionIndexes() {
        return null;
    }

    /**
     * (experimental) Partition columns of the table.
     * <p>
     * Default: table is not partitioned
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.Column> getPartitionKeys() {
        return null;
    }

    /**
     * (experimental) S3 prefix under which table objects are stored.
     * <p>
     * Default: - No prefix. The data will be stored under the root of the bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getS3Prefix() {
        return null;
    }

    /**
     * (experimental) Indicates whether the table data is stored in subdirectories.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getStoredAsSubDirectories() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TableProps> {
        java.util.List<software.amazon.awscdk.services.glue.Column> columns;
        software.amazon.awscdk.services.glue.IDatabase database;
        software.amazon.awscdk.services.glue.DataFormat dataFormat;
        java.lang.String tableName;
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.Boolean compressed;
        java.lang.String description;
        software.amazon.awscdk.services.glue.TableEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.util.List<software.amazon.awscdk.services.glue.PartitionIndex> partitionIndexes;
        java.util.List<software.amazon.awscdk.services.glue.Column> partitionKeys;
        java.lang.String s3Prefix;
        java.lang.Boolean storedAsSubDirectories;

        /**
         * Sets the value of {@link TableProps#getColumns}
         * @param columns Columns of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder columns(java.util.List<? extends software.amazon.awscdk.services.glue.Column> columns) {
            this.columns = (java.util.List<software.amazon.awscdk.services.glue.Column>)columns;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDatabase}
         * @param database Database in which to store the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder database(software.amazon.awscdk.services.glue.IDatabase database) {
            this.database = database;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDataFormat}
         * @param dataFormat Storage type of the table's data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataFormat(software.amazon.awscdk.services.glue.DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTableName}
         * @param tableName Name of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getBucket}
         * @param bucket S3 bucket in which to store data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getCompressed}
         * @param compressed Indicates whether the table's data is compressed or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressed(java.lang.Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDescription}
         * @param description Description of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryption}
         * @param encryption The kind of encryption to secure the data with.
         *                   You can only provide this option if you are not explicitly passing in a bucket.
         *                   <p>
         *                   If you choose <code>SSE-KMS</code>, you <em>can</em> provide an un-managed KMS key with <code>encryptionKey</code>.
         *                   If you choose <code>CSE-KMS</code>, you <em>must</em> provide an un-managed KMS key with <code>encryptionKey</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryption(software.amazon.awscdk.services.glue.TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for bucket encryption.
         *                      The <code>encryption</code> property must be <code>SSE-KMS</code> or <code>CSE-KMS</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionIndexes}
         * @param partitionIndexes Partition indexes on the table.
         *                         A maximum of 3 indexes
         *                         are allowed on a table. Keys in the index must be part
         *                         of the table's partition keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder partitionIndexes(java.util.List<? extends software.amazon.awscdk.services.glue.PartitionIndex> partitionIndexes) {
            this.partitionIndexes = (java.util.List<software.amazon.awscdk.services.glue.PartitionIndex>)partitionIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionKeys}
         * @param partitionKeys Partition columns of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder partitionKeys(java.util.List<? extends software.amazon.awscdk.services.glue.Column> partitionKeys) {
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.glue.Column>)partitionKeys;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getS3Prefix}
         * @param s3Prefix S3 prefix under which table objects are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Prefix(java.lang.String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getStoredAsSubDirectories}
         * @param storedAsSubDirectories Indicates whether the table data is stored in subdirectories.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storedAsSubDirectories(java.lang.Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableProps {
        private final java.util.List<software.amazon.awscdk.services.glue.Column> columns;
        private final software.amazon.awscdk.services.glue.IDatabase database;
        private final software.amazon.awscdk.services.glue.DataFormat dataFormat;
        private final java.lang.String tableName;
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.Boolean compressed;
        private final java.lang.String description;
        private final software.amazon.awscdk.services.glue.TableEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.util.List<software.amazon.awscdk.services.glue.PartitionIndex> partitionIndexes;
        private final java.util.List<software.amazon.awscdk.services.glue.Column> partitionKeys;
        private final java.lang.String s3Prefix;
        private final java.lang.Boolean storedAsSubDirectories;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Column.class)));
            this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.IDatabase.class));
            this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.compressed = software.amazon.jsii.Kernel.get(this, "compressed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.TableEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.partitionIndexes = software.amazon.jsii.Kernel.get(this, "partitionIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.PartitionIndex.class)));
            this.partitionKeys = software.amazon.jsii.Kernel.get(this, "partitionKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Column.class)));
            this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storedAsSubDirectories = software.amazon.jsii.Kernel.get(this, "storedAsSubDirectories", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.columns = (java.util.List<software.amazon.awscdk.services.glue.Column>)java.util.Objects.requireNonNull(builder.columns, "columns is required");
            this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
            this.dataFormat = java.util.Objects.requireNonNull(builder.dataFormat, "dataFormat is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            this.bucket = builder.bucket;
            this.compressed = builder.compressed;
            this.description = builder.description;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.partitionIndexes = (java.util.List<software.amazon.awscdk.services.glue.PartitionIndex>)builder.partitionIndexes;
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.glue.Column>)builder.partitionKeys;
            this.s3Prefix = builder.s3Prefix;
            this.storedAsSubDirectories = builder.storedAsSubDirectories;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.Column> getColumns() {
            return this.columns;
        }

        @Override
        public final software.amazon.awscdk.services.glue.IDatabase getDatabase() {
            return this.database;
        }

        @Override
        public final software.amazon.awscdk.services.glue.DataFormat getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.Boolean getCompressed() {
            return this.compressed;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.glue.TableEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.PartitionIndex> getPartitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.Column> getPartitionKeys() {
            return this.partitionKeys;
        }

        @Override
        public final java.lang.String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final java.lang.Boolean getStoredAsSubDirectories() {
            return this.storedAsSubDirectories;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("columns", om.valueToTree(this.getColumns()));
            data.set("database", om.valueToTree(this.getDatabase()));
            data.set("dataFormat", om.valueToTree(this.getDataFormat()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getCompressed() != null) {
                data.set("compressed", om.valueToTree(this.getCompressed()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getPartitionIndexes() != null) {
                data.set("partitionIndexes", om.valueToTree(this.getPartitionIndexes()));
            }
            if (this.getPartitionKeys() != null) {
                data.set("partitionKeys", om.valueToTree(this.getPartitionKeys()));
            }
            if (this.getS3Prefix() != null) {
                data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
            }
            if (this.getStoredAsSubDirectories() != null) {
                data.set("storedAsSubDirectories", om.valueToTree(this.getStoredAsSubDirectories()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_glue.TableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableProps.Jsii$Proxy that = (TableProps.Jsii$Proxy) o;

            if (!columns.equals(that.columns)) return false;
            if (!database.equals(that.database)) return false;
            if (!dataFormat.equals(that.dataFormat)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.compressed != null ? !this.compressed.equals(that.compressed) : that.compressed != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.partitionIndexes != null ? !this.partitionIndexes.equals(that.partitionIndexes) : that.partitionIndexes != null) return false;
            if (this.partitionKeys != null ? !this.partitionKeys.equals(that.partitionKeys) : that.partitionKeys != null) return false;
            if (this.s3Prefix != null ? !this.s3Prefix.equals(that.s3Prefix) : that.s3Prefix != null) return false;
            return this.storedAsSubDirectories != null ? this.storedAsSubDirectories.equals(that.storedAsSubDirectories) : that.storedAsSubDirectories == null;
        }

        @Override
        public final int hashCode() {
            int result = this.columns.hashCode();
            result = 31 * result + (this.database.hashCode());
            result = 31 * result + (this.dataFormat.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
            result = 31 * result + (this.compressed != null ? this.compressed.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.partitionIndexes != null ? this.partitionIndexes.hashCode() : 0);
            result = 31 * result + (this.partitionKeys != null ? this.partitionKeys.hashCode() : 0);
            result = 31 * result + (this.s3Prefix != null ? this.s3Prefix.hashCode() : 0);
            result = 31 * result + (this.storedAsSubDirectories != null ? this.storedAsSubDirectories.hashCode() : 0);
            return result;
        }
    }
}
