package software.amazon.awscdk.services.guardduty;

/**
 * A CloudFormation `AWS::GuardDuty::Detector`.
 * <p>
 * The <code>AWS::GuardDuty::Detector</code> resource specifies a new  detector. A detector is an object that represents the  service. A detector is required for  to become operational.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CfnDetector cfnDetector = CfnDetector.Builder.create(this, "MyCfnDetector")
 *         .enable(false)
 *         // the properties below are optional
 *         .dataSources(CFNDataSourceConfigurationsProperty.builder()
 *                 .kubernetes(CFNKubernetesConfigurationProperty.builder()
 *                         .auditLogs(CFNKubernetesAuditLogsConfigurationProperty.builder()
 *                                 .enable(false)
 *                                 .build())
 *                         .build())
 *                 .malwareProtection(CFNMalwareProtectionConfigurationProperty.builder()
 *                         .scanEc2InstanceWithFindings(CFNScanEc2InstanceWithFindingsConfigurationProperty.builder()
 *                                 .ebsVolumes(false)
 *                                 .build())
 *                         .build())
 *                 .s3Logs(CFNS3LogsConfigurationProperty.builder()
 *                         .enable(false)
 *                         .build())
 *                 .build())
 *         .findingPublishingFrequency("findingPublishingFrequency")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector")
public class CfnDetector extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDetector(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDetector(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.guardduty.CfnDetector.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::GuardDuty::Detector`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDetector(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.guardduty.CfnDetectorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to be added to a new detector resource.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Specifies whether the detector is to be enabled on creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEnable() {
        return software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the detector is to be enabled on creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enable", java.util.Objects.requireNonNull(value, "enable is required"));
    }

    /**
     * Specifies whether the detector is to be enabled on creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enable", java.util.Objects.requireNonNull(value, "enable is required"));
    }

    /**
     * Describes which data sources will be enabled for the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSources() {
        return software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes which data sources will be enabled for the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.guardduty.CfnDetector.CFNDataSourceConfigurationsProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataSources", value);
    }

    /**
     * Describes which data sources will be enabled for the detector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSources", value);
    }

    /**
     * Specifies how frequently updated findings are exported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFindingPublishingFrequency() {
        return software.amazon.jsii.Kernel.get(this, "findingPublishingFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how frequently updated findings are exported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFindingPublishingFrequency(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "findingPublishingFrequency", value);
    }
    /**
     * Describes whether S3 data event logs, Kubernetes audit logs, or Malware Protection will be enabled as a data source when the detector is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNDataSourceConfigurationsProperty cFNDataSourceConfigurationsProperty = CFNDataSourceConfigurationsProperty.builder()
     *         .kubernetes(CFNKubernetesConfigurationProperty.builder()
     *                 .auditLogs(CFNKubernetesAuditLogsConfigurationProperty.builder()
     *                         .enable(false)
     *                         .build())
     *                 .build())
     *         .malwareProtection(CFNMalwareProtectionConfigurationProperty.builder()
     *                 .scanEc2InstanceWithFindings(CFNScanEc2InstanceWithFindingsConfigurationProperty.builder()
     *                         .ebsVolumes(false)
     *                         .build())
     *                 .build())
     *         .s3Logs(CFNS3LogsConfigurationProperty.builder()
     *                 .enable(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNDataSourceConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNDataSourceConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNDataSourceConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes which Kuberentes data sources are enabled for a detector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKubernetes() {
            return null;
        }

        /**
         * Describes whether Malware Protection will be enabled as a data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMalwareProtection() {
            return null;
        }

        /**
         * Describes whether S3 data event logs are enabled as a data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Logs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNDataSourceConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNDataSourceConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNDataSourceConfigurationsProperty> {
            java.lang.Object kubernetes;
            java.lang.Object malwareProtection;
            java.lang.Object s3Logs;

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getKubernetes}
             * @param kubernetes Describes which Kuberentes data sources are enabled for a detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kubernetes(software.amazon.awscdk.services.guardduty.CfnDetector.CFNKubernetesConfigurationProperty kubernetes) {
                this.kubernetes = kubernetes;
                return this;
            }

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getKubernetes}
             * @param kubernetes Describes which Kuberentes data sources are enabled for a detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kubernetes(software.amazon.awscdk.core.IResolvable kubernetes) {
                this.kubernetes = kubernetes;
                return this;
            }

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getMalwareProtection}
             * @param malwareProtection Describes whether Malware Protection will be enabled as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareProtection(software.amazon.awscdk.services.guardduty.CfnDetector.CFNMalwareProtectionConfigurationProperty malwareProtection) {
                this.malwareProtection = malwareProtection;
                return this;
            }

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getMalwareProtection}
             * @param malwareProtection Describes whether Malware Protection will be enabled as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder malwareProtection(software.amazon.awscdk.core.IResolvable malwareProtection) {
                this.malwareProtection = malwareProtection;
                return this;
            }

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getS3Logs}
             * @param s3Logs Describes whether S3 data event logs are enabled as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.services.guardduty.CfnDetector.CFNS3LogsConfigurationProperty s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Sets the value of {@link CFNDataSourceConfigurationsProperty#getS3Logs}
             * @param s3Logs Describes whether S3 data event logs are enabled as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Logs(software.amazon.awscdk.core.IResolvable s3Logs) {
                this.s3Logs = s3Logs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNDataSourceConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNDataSourceConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNDataSourceConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNDataSourceConfigurationsProperty {
            private final java.lang.Object kubernetes;
            private final java.lang.Object malwareProtection;
            private final java.lang.Object s3Logs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kubernetes = software.amazon.jsii.Kernel.get(this, "kubernetes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.malwareProtection = software.amazon.jsii.Kernel.get(this, "malwareProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Logs = software.amazon.jsii.Kernel.get(this, "s3Logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kubernetes = builder.kubernetes;
                this.malwareProtection = builder.malwareProtection;
                this.s3Logs = builder.s3Logs;
            }

            @Override
            public final java.lang.Object getKubernetes() {
                return this.kubernetes;
            }

            @Override
            public final java.lang.Object getMalwareProtection() {
                return this.malwareProtection;
            }

            @Override
            public final java.lang.Object getS3Logs() {
                return this.s3Logs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKubernetes() != null) {
                    data.set("kubernetes", om.valueToTree(this.getKubernetes()));
                }
                if (this.getMalwareProtection() != null) {
                    data.set("malwareProtection", om.valueToTree(this.getMalwareProtection()));
                }
                if (this.getS3Logs() != null) {
                    data.set("s3Logs", om.valueToTree(this.getS3Logs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNDataSourceConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNDataSourceConfigurationsProperty.Jsii$Proxy that = (CFNDataSourceConfigurationsProperty.Jsii$Proxy) o;

                if (this.kubernetes != null ? !this.kubernetes.equals(that.kubernetes) : that.kubernetes != null) return false;
                if (this.malwareProtection != null ? !this.malwareProtection.equals(that.malwareProtection) : that.malwareProtection != null) return false;
                return this.s3Logs != null ? this.s3Logs.equals(that.s3Logs) : that.s3Logs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kubernetes != null ? this.kubernetes.hashCode() : 0;
                result = 31 * result + (this.malwareProtection != null ? this.malwareProtection.hashCode() : 0);
                result = 31 * result + (this.s3Logs != null ? this.s3Logs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes which optional data sources are enabled for a detector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNKubernetesAuditLogsConfigurationProperty cFNKubernetesAuditLogsConfigurationProperty = CFNKubernetesAuditLogsConfigurationProperty.builder()
     *         .enable(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNKubernetesAuditLogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNKubernetesAuditLogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNKubernetesAuditLogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether Kubernetes audit logs are enabled as a data source for the detector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNKubernetesAuditLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNKubernetesAuditLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNKubernetesAuditLogsConfigurationProperty> {
            java.lang.Object enable;

            /**
             * Sets the value of {@link CFNKubernetesAuditLogsConfigurationProperty#getEnable}
             * @param enable Describes whether Kubernetes audit logs are enabled as a data source for the detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link CFNKubernetesAuditLogsConfigurationProperty#getEnable}
             * @param enable Describes whether Kubernetes audit logs are enabled as a data source for the detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.core.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNKubernetesAuditLogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNKubernetesAuditLogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNKubernetesAuditLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNKubernetesAuditLogsConfigurationProperty {
            private final java.lang.Object enable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enable = builder.enable;
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnable() != null) {
                    data.set("enable", om.valueToTree(this.getEnable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNKubernetesAuditLogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNKubernetesAuditLogsConfigurationProperty.Jsii$Proxy that = (CFNKubernetesAuditLogsConfigurationProperty.Jsii$Proxy) o;

                return this.enable != null ? this.enable.equals(that.enable) : that.enable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enable != null ? this.enable.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes which Kubernetes protection data sources are enabled for the detector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNKubernetesConfigurationProperty cFNKubernetesConfigurationProperty = CFNKubernetesConfigurationProperty.builder()
     *         .auditLogs(CFNKubernetesAuditLogsConfigurationProperty.builder()
     *                 .enable(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNKubernetesConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNKubernetesConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNKubernetesConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes whether Kubernetes audit logs are enabled as a data source for the detector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuditLogs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNKubernetesConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNKubernetesConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNKubernetesConfigurationProperty> {
            java.lang.Object auditLogs;

            /**
             * Sets the value of {@link CFNKubernetesConfigurationProperty#getAuditLogs}
             * @param auditLogs Describes whether Kubernetes audit logs are enabled as a data source for the detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogs(software.amazon.awscdk.services.guardduty.CfnDetector.CFNKubernetesAuditLogsConfigurationProperty auditLogs) {
                this.auditLogs = auditLogs;
                return this;
            }

            /**
             * Sets the value of {@link CFNKubernetesConfigurationProperty#getAuditLogs}
             * @param auditLogs Describes whether Kubernetes audit logs are enabled as a data source for the detector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder auditLogs(software.amazon.awscdk.core.IResolvable auditLogs) {
                this.auditLogs = auditLogs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNKubernetesConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNKubernetesConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNKubernetesConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNKubernetesConfigurationProperty {
            private final java.lang.Object auditLogs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.auditLogs = software.amazon.jsii.Kernel.get(this, "auditLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.auditLogs = builder.auditLogs;
            }

            @Override
            public final java.lang.Object getAuditLogs() {
                return this.auditLogs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuditLogs() != null) {
                    data.set("auditLogs", om.valueToTree(this.getAuditLogs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNKubernetesConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNKubernetesConfigurationProperty.Jsii$Proxy that = (CFNKubernetesConfigurationProperty.Jsii$Proxy) o;

                return this.auditLogs != null ? this.auditLogs.equals(that.auditLogs) : that.auditLogs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.auditLogs != null ? this.auditLogs.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes whether Malware Protection will be enabled as a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNMalwareProtectionConfigurationProperty cFNMalwareProtectionConfigurationProperty = CFNMalwareProtectionConfigurationProperty.builder()
     *         .scanEc2InstanceWithFindings(CFNScanEc2InstanceWithFindingsConfigurationProperty.builder()
     *                 .ebsVolumes(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNMalwareProtectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNMalwareProtectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNMalwareProtectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the configuration of Malware Protection for EC2 instances with findings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScanEc2InstanceWithFindings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNMalwareProtectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNMalwareProtectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNMalwareProtectionConfigurationProperty> {
            java.lang.Object scanEc2InstanceWithFindings;

            /**
             * Sets the value of {@link CFNMalwareProtectionConfigurationProperty#getScanEc2InstanceWithFindings}
             * @param scanEc2InstanceWithFindings Describes the configuration of Malware Protection for EC2 instances with findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scanEc2InstanceWithFindings(software.amazon.awscdk.services.guardduty.CfnDetector.CFNScanEc2InstanceWithFindingsConfigurationProperty scanEc2InstanceWithFindings) {
                this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
                return this;
            }

            /**
             * Sets the value of {@link CFNMalwareProtectionConfigurationProperty#getScanEc2InstanceWithFindings}
             * @param scanEc2InstanceWithFindings Describes the configuration of Malware Protection for EC2 instances with findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scanEc2InstanceWithFindings(software.amazon.awscdk.core.IResolvable scanEc2InstanceWithFindings) {
                this.scanEc2InstanceWithFindings = scanEc2InstanceWithFindings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNMalwareProtectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNMalwareProtectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNMalwareProtectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNMalwareProtectionConfigurationProperty {
            private final java.lang.Object scanEc2InstanceWithFindings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scanEc2InstanceWithFindings = software.amazon.jsii.Kernel.get(this, "scanEc2InstanceWithFindings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scanEc2InstanceWithFindings = builder.scanEc2InstanceWithFindings;
            }

            @Override
            public final java.lang.Object getScanEc2InstanceWithFindings() {
                return this.scanEc2InstanceWithFindings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScanEc2InstanceWithFindings() != null) {
                    data.set("scanEc2InstanceWithFindings", om.valueToTree(this.getScanEc2InstanceWithFindings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNMalwareProtectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNMalwareProtectionConfigurationProperty.Jsii$Proxy that = (CFNMalwareProtectionConfigurationProperty.Jsii$Proxy) o;

                return this.scanEc2InstanceWithFindings != null ? this.scanEc2InstanceWithFindings.equals(that.scanEc2InstanceWithFindings) : that.scanEc2InstanceWithFindings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scanEc2InstanceWithFindings != null ? this.scanEc2InstanceWithFindings.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes whether S3 data event logs will be enabled as a data source when the detector is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNS3LogsConfigurationProperty cFNS3LogsConfigurationProperty = CFNS3LogsConfigurationProperty.builder()
     *         .enable(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNS3LogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNS3LogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNS3LogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of S3 data event logs as a data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNS3LogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNS3LogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNS3LogsConfigurationProperty> {
            java.lang.Object enable;

            /**
             * Sets the value of {@link CFNS3LogsConfigurationProperty#getEnable}
             * @param enable The status of S3 data event logs as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link CFNS3LogsConfigurationProperty#getEnable}
             * @param enable The status of S3 data event logs as a data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.core.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNS3LogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNS3LogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNS3LogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNS3LogsConfigurationProperty {
            private final java.lang.Object enable;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enable = builder.enable;
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnable() != null) {
                    data.set("enable", om.valueToTree(this.getEnable()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNS3LogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNS3LogsConfigurationProperty.Jsii$Proxy that = (CFNS3LogsConfigurationProperty.Jsii$Proxy) o;

                return this.enable != null ? this.enable.equals(that.enable) : that.enable == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enable != null ? this.enable.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes whether Malware Protection for EC2 instances with findings will be enabled as a data source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.guardduty.*;
     * CFNScanEc2InstanceWithFindingsConfigurationProperty cFNScanEc2InstanceWithFindingsConfigurationProperty = CFNScanEc2InstanceWithFindingsConfigurationProperty.builder()
     *         .ebsVolumes(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_guardduty.CfnDetector.CFNScanEc2InstanceWithFindingsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CFNScanEc2InstanceWithFindingsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CFNScanEc2InstanceWithFindingsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the configuration for scanning EBS volumes as data source.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CFNScanEc2InstanceWithFindingsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CFNScanEc2InstanceWithFindingsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CFNScanEc2InstanceWithFindingsConfigurationProperty> {
            java.lang.Object ebsVolumes;

            /**
             * Sets the value of {@link CFNScanEc2InstanceWithFindingsConfigurationProperty#getEbsVolumes}
             * @param ebsVolumes Describes the configuration for scanning EBS volumes as data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumes(java.lang.Boolean ebsVolumes) {
                this.ebsVolumes = ebsVolumes;
                return this;
            }

            /**
             * Sets the value of {@link CFNScanEc2InstanceWithFindingsConfigurationProperty#getEbsVolumes}
             * @param ebsVolumes Describes the configuration for scanning EBS volumes as data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumes(software.amazon.awscdk.core.IResolvable ebsVolumes) {
                this.ebsVolumes = ebsVolumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CFNScanEc2InstanceWithFindingsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CFNScanEc2InstanceWithFindingsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CFNScanEc2InstanceWithFindingsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CFNScanEc2InstanceWithFindingsConfigurationProperty {
            private final java.lang.Object ebsVolumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsVolumes = software.amazon.jsii.Kernel.get(this, "ebsVolumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsVolumes = builder.ebsVolumes;
            }

            @Override
            public final java.lang.Object getEbsVolumes() {
                return this.ebsVolumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsVolumes() != null) {
                    data.set("ebsVolumes", om.valueToTree(this.getEbsVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_guardduty.CfnDetector.CFNScanEc2InstanceWithFindingsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CFNScanEc2InstanceWithFindingsConfigurationProperty.Jsii$Proxy that = (CFNScanEc2InstanceWithFindingsConfigurationProperty.Jsii$Proxy) o;

                return this.ebsVolumes != null ? this.ebsVolumes.equals(that.ebsVolumes) : that.ebsVolumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsVolumes != null ? this.ebsVolumes.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.guardduty.CfnDetector}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.guardduty.CfnDetector> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.guardduty.CfnDetectorProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.guardduty.CfnDetectorProps.Builder();
        }

        /**
         * Specifies whether the detector is to be enabled on creation.
         * <p>
         * @return {@code this}
         * @param enable Specifies whether the detector is to be enabled on creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final java.lang.Boolean enable) {
            this.props.enable(enable);
            return this;
        }
        /**
         * Specifies whether the detector is to be enabled on creation.
         * <p>
         * @return {@code this}
         * @param enable Specifies whether the detector is to be enabled on creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final software.amazon.awscdk.core.IResolvable enable) {
            this.props.enable(enable);
            return this;
        }

        /**
         * Describes which data sources will be enabled for the detector.
         * <p>
         * @return {@code this}
         * @param dataSources Describes which data sources will be enabled for the detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(final software.amazon.awscdk.services.guardduty.CfnDetector.CFNDataSourceConfigurationsProperty dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }
        /**
         * Describes which data sources will be enabled for the detector.
         * <p>
         * @return {@code this}
         * @param dataSources Describes which data sources will be enabled for the detector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(final software.amazon.awscdk.core.IResolvable dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        /**
         * Specifies how frequently updated findings are exported.
         * <p>
         * @return {@code this}
         * @param findingPublishingFrequency Specifies how frequently updated findings are exported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingPublishingFrequency(final java.lang.String findingPublishingFrequency) {
            this.props.findingPublishingFrequency(findingPublishingFrequency);
            return this;
        }

        /**
         * The tags to be added to a new detector resource.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags The tags to be added to a new detector resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.guardduty.CfnDetector}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.guardduty.CfnDetector build() {
            return new software.amazon.awscdk.services.guardduty.CfnDetector(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
