package software.amazon.awscdk.services.inspector;

/**
 * A CloudFormation `AWS::Inspector::AssessmentTemplate`.
 * <p>
 * The <code>AWS::Inspector::AssessmentTemplate</code> resource creates an Amazon Inspector assessment template, which specifies the Inspector assessment targets that will be evaluated by an assessment run and its related configurations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspector.*;
 * CfnAssessmentTemplate cfnAssessmentTemplate = CfnAssessmentTemplate.Builder.create(this, "MyCfnAssessmentTemplate")
 *         .assessmentTargetArn("assessmentTargetArn")
 *         .durationInSeconds(123)
 *         .rulesPackageArns(List.of("rulesPackageArns"))
 *         // the properties below are optional
 *         .assessmentTemplateName("assessmentTemplateName")
 *         .userAttributesForFindings(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:02.985Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_inspector.CfnAssessmentTemplate")
public class CfnAssessmentTemplate extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnAssessmentTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAssessmentTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.inspector.CfnAssessmentTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Inspector::AssessmentTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAssessmentTemplate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.inspector.CfnAssessmentTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) that specifies the assessment template that is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ARN of the assessment target to be included in the assessment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssessmentTargetArn() {
        return software.amazon.jsii.Kernel.get(this, "assessmentTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the assessment target to be included in the assessment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssessmentTargetArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assessmentTargetArn", java.util.Objects.requireNonNull(value, "assessmentTargetArn is required"));
    }

    /**
     * The duration of the assessment run in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getDurationInSeconds() {
        return software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The duration of the assessment run in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDurationInSeconds(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "durationInSeconds", java.util.Objects.requireNonNull(value, "durationInSeconds is required"));
    }

    /**
     * The ARNs of the rules packages that you want to use in the assessment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRulesPackageArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "rulesPackageArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ARNs of the rules packages that you want to use in the assessment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRulesPackageArns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "rulesPackageArns", java.util.Objects.requireNonNull(value, "rulesPackageArns is required"));
    }

    /**
     * The user-defined name that identifies the assessment template that you want to create.
     * <p>
     * You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAssessmentTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "assessmentTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-defined name that identifies the assessment template that you want to create.
     * <p>
     * You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssessmentTemplateName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assessmentTemplateName", value);
    }

    /**
     * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
     * <p>
     * Within an assessment template, each key must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUserAttributesForFindings() {
        return software.amazon.jsii.Kernel.get(this, "userAttributesForFindings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
     * <p>
     * Within an assessment template, each key must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserAttributesForFindings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "userAttributesForFindings", value);
    }

    /**
     * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
     * <p>
     * Within an assessment template, each key must be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserAttributesForFindings(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.core.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.core.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.core.IResolvable, software.amazon.awscdk.core.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "userAttributesForFindings", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.inspector.CfnAssessmentTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.inspector.CfnAssessmentTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.inspector.CfnAssessmentTemplateProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.inspector.CfnAssessmentTemplateProps.Builder();
        }

        /**
         * The ARN of the assessment target to be included in the assessment template.
         * <p>
         * @return {@code this}
         * @param assessmentTargetArn The ARN of the assessment target to be included in the assessment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentTargetArn(final java.lang.String assessmentTargetArn) {
            this.props.assessmentTargetArn(assessmentTargetArn);
            return this;
        }

        /**
         * The duration of the assessment run in seconds.
         * <p>
         * @return {@code this}
         * @param durationInSeconds The duration of the assessment run in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder durationInSeconds(final java.lang.Number durationInSeconds) {
            this.props.durationInSeconds(durationInSeconds);
            return this;
        }

        /**
         * The ARNs of the rules packages that you want to use in the assessment template.
         * <p>
         * @return {@code this}
         * @param rulesPackageArns The ARNs of the rules packages that you want to use in the assessment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rulesPackageArns(final java.util.List<java.lang.String> rulesPackageArns) {
            this.props.rulesPackageArns(rulesPackageArns);
            return this;
        }

        /**
         * The user-defined name that identifies the assessment template that you want to create.
         * <p>
         * You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
         * <p>
         * @return {@code this}
         * @param assessmentTemplateName The user-defined name that identifies the assessment template that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assessmentTemplateName(final java.lang.String assessmentTemplateName) {
            this.props.assessmentTemplateName(assessmentTemplateName);
            return this;
        }

        /**
         * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
         * <p>
         * Within an assessment template, each key must be unique.
         * <p>
         * @return {@code this}
         * @param userAttributesForFindings The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributesForFindings(final software.amazon.awscdk.core.IResolvable userAttributesForFindings) {
            this.props.userAttributesForFindings(userAttributesForFindings);
            return this;
        }
        /**
         * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
         * <p>
         * Within an assessment template, each key must be unique.
         * <p>
         * @return {@code this}
         * @param userAttributesForFindings The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userAttributesForFindings(final java.util.List<? extends java.lang.Object> userAttributesForFindings) {
            this.props.userAttributesForFindings(userAttributesForFindings);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.inspector.CfnAssessmentTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.inspector.CfnAssessmentTemplate build() {
            return new software.amazon.awscdk.services.inspector.CfnAssessmentTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
