package software.amazon.awscdk.services.iot;

/**
 * (experimental) Properties for an topic rule action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * ActionConfig actionConfig = ActionConfig.builder()
 *         .configuration(ActionProperty.builder()
 *                 .cloudwatchAlarm(CloudwatchAlarmActionProperty.builder()
 *                         .alarmName("alarmName")
 *                         .roleArn("roleArn")
 *                         .stateReason("stateReason")
 *                         .stateValue("stateValue")
 *                         .build())
 *                 .cloudwatchLogs(CloudwatchLogsActionProperty.builder()
 *                         .logGroupName("logGroupName")
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .cloudwatchMetric(CloudwatchMetricActionProperty.builder()
 *                         .metricName("metricName")
 *                         .metricNamespace("metricNamespace")
 *                         .metricUnit("metricUnit")
 *                         .metricValue("metricValue")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .metricTimestamp("metricTimestamp")
 *                         .build())
 *                 .dynamoDb(DynamoDBActionProperty.builder()
 *                         .hashKeyField("hashKeyField")
 *                         .hashKeyValue("hashKeyValue")
 *                         .roleArn("roleArn")
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .hashKeyType("hashKeyType")
 *                         .payloadField("payloadField")
 *                         .rangeKeyField("rangeKeyField")
 *                         .rangeKeyType("rangeKeyType")
 *                         .rangeKeyValue("rangeKeyValue")
 *                         .build())
 *                 .dynamoDBv2(DynamoDBv2ActionProperty.builder()
 *                         .putItem(PutItemInputProperty.builder()
 *                                 .tableName("tableName")
 *                                 .build())
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .elasticsearch(ElasticsearchActionProperty.builder()
 *                         .endpoint("endpoint")
 *                         .id("id")
 *                         .index("index")
 *                         .roleArn("roleArn")
 *                         .type("type")
 *                         .build())
 *                 .firehose(FirehoseActionProperty.builder()
 *                         .deliveryStreamName("deliveryStreamName")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .batchMode(false)
 *                         .separator("separator")
 *                         .build())
 *                 .http(HttpActionProperty.builder()
 *                         .url("url")
 *                         // the properties below are optional
 *                         .auth(HttpAuthorizationProperty.builder()
 *                                 .sigv4(SigV4AuthorizationProperty.builder()
 *                                         .roleArn("roleArn")
 *                                         .serviceName("serviceName")
 *                                         .signingRegion("signingRegion")
 *                                         .build())
 *                                 .build())
 *                         .confirmationUrl("confirmationUrl")
 *                         .headers(List.of(HttpActionHeaderProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .iotAnalytics(IotAnalyticsActionProperty.builder()
 *                         .channelName("channelName")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .batchMode(false)
 *                         .build())
 *                 .iotEvents(IotEventsActionProperty.builder()
 *                         .inputName("inputName")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .batchMode(false)
 *                         .messageId("messageId")
 *                         .build())
 *                 .iotSiteWise(IotSiteWiseActionProperty.builder()
 *                         .putAssetPropertyValueEntries(List.of(PutAssetPropertyValueEntryProperty.builder()
 *                                 .propertyValues(List.of(AssetPropertyValueProperty.builder()
 *                                         .timestamp(AssetPropertyTimestampProperty.builder()
 *                                                 .timeInSeconds("timeInSeconds")
 *                                                 // the properties below are optional
 *                                                 .offsetInNanos("offsetInNanos")
 *                                                 .build())
 *                                         .value(AssetPropertyVariantProperty.builder()
 *                                                 .booleanValue("booleanValue")
 *                                                 .doubleValue("doubleValue")
 *                                                 .integerValue("integerValue")
 *                                                 .stringValue("stringValue")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .quality("quality")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .assetId("assetId")
 *                                 .entryId("entryId")
 *                                 .propertyAlias("propertyAlias")
 *                                 .propertyId("propertyId")
 *                                 .build()))
 *                         .roleArn("roleArn")
 *                         .build())
 *                 .kafka(KafkaActionProperty.builder()
 *                         .clientProperties(Map.of(
 *                                 "clientPropertiesKey", "clientProperties"))
 *                         .destinationArn("destinationArn")
 *                         .topic("topic")
 *                         // the properties below are optional
 *                         .key("key")
 *                         .partition("partition")
 *                         .build())
 *                 .kinesis(KinesisActionProperty.builder()
 *                         .roleArn("roleArn")
 *                         .streamName("streamName")
 *                         // the properties below are optional
 *                         .partitionKey("partitionKey")
 *                         .build())
 *                 .lambda(LambdaActionProperty.builder()
 *                         .functionArn("functionArn")
 *                         .build())
 *                 .location(LocationActionProperty.builder()
 *                         .deviceId("deviceId")
 *                         .latitude("latitude")
 *                         .longitude("longitude")
 *                         .roleArn("roleArn")
 *                         .trackerName("trackerName")
 *                         // the properties below are optional
 *                         .timestamp(new Date())
 *                         .build())
 *                 .openSearch(OpenSearchActionProperty.builder()
 *                         .endpoint("endpoint")
 *                         .id("id")
 *                         .index("index")
 *                         .roleArn("roleArn")
 *                         .type("type")
 *                         .build())
 *                 .republish(RepublishActionProperty.builder()
 *                         .roleArn("roleArn")
 *                         .topic("topic")
 *                         // the properties below are optional
 *                         .headers(RepublishActionHeadersProperty.builder()
 *                                 .contentType("contentType")
 *                                 .correlationData("correlationData")
 *                                 .messageExpiry("messageExpiry")
 *                                 .payloadFormatIndicator("payloadFormatIndicator")
 *                                 .responseTopic("responseTopic")
 *                                 .userProperties(List.of(UserPropertyProperty.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build())
 *                         .qos(123)
 *                         .build())
 *                 .s3(S3ActionProperty.builder()
 *                         .bucketName("bucketName")
 *                         .key("key")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .cannedAcl("cannedAcl")
 *                         .build())
 *                 .sns(SnsActionProperty.builder()
 *                         .roleArn("roleArn")
 *                         .targetArn("targetArn")
 *                         // the properties below are optional
 *                         .messageFormat("messageFormat")
 *                         .build())
 *                 .sqs(SqsActionProperty.builder()
 *                         .queueUrl("queueUrl")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .useBase64(false)
 *                         .build())
 *                 .stepFunctions(StepFunctionsActionProperty.builder()
 *                         .roleArn("roleArn")
 *                         .stateMachineName("stateMachineName")
 *                         // the properties below are optional
 *                         .executionNamePrefix("executionNamePrefix")
 *                         .build())
 *                 .timestream(TimestreamActionProperty.builder()
 *                         .databaseName("databaseName")
 *                         .dimensions(List.of(TimestreamDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .roleArn("roleArn")
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .timestamp(TimestreamTimestampProperty.builder()
 *                                 .unit("unit")
 *                                 .value("value")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.039Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot.ActionConfig")
@software.amazon.jsii.Jsii.Proxy(ActionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ActionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The configuration for this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty getConfiguration();

    /**
     * @return a {@link Builder} of {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ActionConfig> {
        software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty configuration;

        /**
         * Sets the value of {@link ActionConfig#getConfiguration}
         * @param configuration The configuration for this action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configuration(software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ActionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionConfig {
        private final software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty configuration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
        }

        @Override
        public final software.amazon.awscdk.services.iot.CfnTopicRule.ActionProperty getConfiguration() {
            return this.configuration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot.ActionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionConfig.Jsii$Proxy that = (ActionConfig.Jsii$Proxy) o;

            return this.configuration.equals(that.configuration);
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            return result;
        }
    }
}
