package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) Configuration properties of an action for CloudWatch alarm.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Metric metric = Metric.Builder.create()
 *         .namespace("MyNamespace")
 *         .metricName("MyMetric")
 *         .dimensions(Map.of("MyDimension", "MyDimensionValue"))
 *         .build();
 * Alarm alarm = Alarm.Builder.create(this, "MyAlarm")
 *         .metric(metric)
 *         .threshold(100)
 *         .evaluationPeriods(3)
 *         .datapointsToAlarm(2)
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id FROM 'device/+/data'"))
 *         .actions(List.of(
 *             CloudWatchSetAlarmStateAction.Builder.create(alarm)
 *                     .reason("AWS Iot Rule action is triggered")
 *                     .alarmStateToSet(AlarmState.ALARM)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.330Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.CloudWatchSetAlarmStateActionProps")
@software.amazon.jsii.Jsii.Proxy(CloudWatchSetAlarmStateActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CloudWatchSetAlarmStateActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.iot.actions.CommonActionProps {

    /**
     * (experimental) The value of the alarm state to set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmState getAlarmStateToSet();

    /**
     * (experimental) The reason for the alarm change.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getReason() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudWatchSetAlarmStateActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudWatchSetAlarmStateActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CloudWatchSetAlarmStateActionProps> {
        software.amazon.awscdk.services.cloudwatch.AlarmState alarmStateToSet;
        java.lang.String reason;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link CloudWatchSetAlarmStateActionProps#getAlarmStateToSet}
         * @param alarmStateToSet The value of the alarm state to set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder alarmStateToSet(software.amazon.awscdk.services.cloudwatch.AlarmState alarmStateToSet) {
            this.alarmStateToSet = alarmStateToSet;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchSetAlarmStateActionProps#getReason}
         * @param reason The reason for the alarm change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reason(java.lang.String reason) {
            this.reason = reason;
            return this;
        }

        /**
         * Sets the value of {@link CloudWatchSetAlarmStateActionProps#getRole}
         * @param role The IAM role that allows access to AWS service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudWatchSetAlarmStateActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CloudWatchSetAlarmStateActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudWatchSetAlarmStateActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchSetAlarmStateActionProps {
        private final software.amazon.awscdk.services.cloudwatch.AlarmState alarmStateToSet;
        private final java.lang.String reason;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alarmStateToSet = software.amazon.jsii.Kernel.get(this, "alarmStateToSet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmState.class));
            this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alarmStateToSet = java.util.Objects.requireNonNull(builder.alarmStateToSet, "alarmStateToSet is required");
            this.reason = builder.reason;
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.AlarmState getAlarmStateToSet() {
            return this.alarmStateToSet;
        }

        @Override
        public final java.lang.String getReason() {
            return this.reason;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alarmStateToSet", om.valueToTree(this.getAlarmStateToSet()));
            if (this.getReason() != null) {
                data.set("reason", om.valueToTree(this.getReason()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot_actions.CloudWatchSetAlarmStateActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudWatchSetAlarmStateActionProps.Jsii$Proxy that = (CloudWatchSetAlarmStateActionProps.Jsii$Proxy) o;

            if (!alarmStateToSet.equals(that.alarmStateToSet)) return false;
            if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alarmStateToSet.hashCode();
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
