package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * Bucket bucket = new Bucket(this, "MyBucket");
 * DeliveryStream stream = DeliveryStream.Builder.create(this, "MyStream")
 *         .destinations(List.of(new S3Bucket(bucket)))
 *         .build();
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT * FROM 'device/+/data'"))
 *         .actions(List.of(
 *             FirehosePutRecordAction.Builder.create(stream)
 *                     .batchMode(true)
 *                     .recordSeparator(FirehoseRecordSeparator.NEWLINE)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.333Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.FirehosePutRecordAction")
public class FirehosePutRecordAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected FirehosePutRecordAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehosePutRecordAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stream The Kinesis Data Firehose stream to which to put records. This parameter is required.
     * @param props Optional properties to not use default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public FirehosePutRecordAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.FirehosePutRecordActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required"), props });
    }

    /**
     * @param stream The Kinesis Data Firehose stream to which to put records. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public FirehosePutRecordAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stream, "stream is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.FirehosePutRecordAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.FirehosePutRecordAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param stream The Kinesis Data Firehose stream to which to put records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
            return new Builder(stream);
        }

        private final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream;
        private software.amazon.awscdk.services.iot.actions.FirehosePutRecordActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream stream) {
            this.stream = stream;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`.
         * <p>
         * When batchMode is true and the rule's SQL statement evaluates to an Array, each Array
         * element forms one record in the PutRecordBatch request. The resulting array can't have
         * more than 500 records.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param batchMode Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder batchMode(final java.lang.Boolean batchMode) {
            this.props().batchMode(batchMode);
            return this;
        }

        /**
         * (experimental) A character separator that will be used to separate records written to the Kinesis Data Firehose stream.
         * <p>
         * Default: - none -- the stream does not use a separator
         * <p>
         * @return {@code this}
         * @param recordSeparator A character separator that will be used to separate records written to the Kinesis Data Firehose stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder recordSeparator(final software.amazon.awscdk.services.iot.actions.FirehoseRecordSeparator recordSeparator) {
            this.props().recordSeparator(recordSeparator);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.FirehosePutRecordAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.FirehosePutRecordAction build() {
            return new software.amazon.awscdk.services.iot.actions.FirehosePutRecordAction(
                this.stream,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.FirehosePutRecordActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.FirehosePutRecordActionProps.Builder();
            }
            return this.props;
        }
    }
}
