package software.amazon.awscdk.services.iot.actions;

/**
 * (experimental) The action to write the data from an MQTT message to an Amazon SNS topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * Topic topic = new Topic(this, "MyTopic");
 * TopicRule topicRule = TopicRule.Builder.create(this, "TopicRule")
 *         .sql(IotSql.fromStringAsVer20160323("SELECT topic(2) as device_id, year, month, day FROM 'device/+/data'"))
 *         .actions(List.of(
 *             SnsTopicAction.Builder.create(topic)
 *                     .messageFormat(SnsActionMessageFormat.JSON)
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html">https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.348Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot_actions.SnsTopicAction")
public class SnsTopicAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iot.IAction {

    protected SnsTopicAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnsTopicAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic The Amazon SNS topic to publish data on. This parameter is required.
     * @param props Properties to configure the action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SnsTopicAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.actions.SnsTopicActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required"), props });
    }

    /**
     * @param topic The Amazon SNS topic to publish data on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SnsTopicAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * (experimental) Returns the topic rule action specification.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.ITopicRule rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iot.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iot.actions.SnsTopicAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.actions.SnsTopicAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param topic The Amazon SNS topic to publish data on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.amazon.awscdk.services.sns.ITopic topic) {
            return new Builder(topic);
        }

        private final software.amazon.awscdk.services.sns.ITopic topic;
        private software.amazon.awscdk.services.iot.actions.SnsTopicActionProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
        }

        /**
         * (experimental) The IAM role that allows access to AWS service.
         * <p>
         * Default: a new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that allows access to AWS service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) The message format of the message to publish.
         * <p>
         * SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted.
         * <p>
         * Default: SnsActionMessageFormat.RAW
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-message-and-json-formats.html">https://docs.aws.amazon.com/sns/latest/dg/sns-message-and-json-formats.html</a>
         * @param messageFormat The message format of the message to publish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder messageFormat(final software.amazon.awscdk.services.iot.actions.SnsActionMessageFormat messageFormat) {
            this.props().messageFormat(messageFormat);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.actions.SnsTopicAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iot.actions.SnsTopicAction build() {
            return new software.amazon.awscdk.services.iot.actions.SnsTopicAction(
                this.topic,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.iot.actions.SnsTopicActionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.iot.actions.SnsTopicActionProps.Builder();
            }
            return this.props;
        }
    }
}
