package software.amazon.awscdk.services.iot1click;

/**
 * Properties for defining a `CfnPlacement`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot1click.*;
 * Object associatedDevices;
 * Object attributes;
 * CfnPlacementProps cfnPlacementProps = CfnPlacementProps.builder()
 *         .projectName("projectName")
 *         // the properties below are optional
 *         .associatedDevices(associatedDevices)
 *         .attributes(attributes)
 *         .placementName("placementName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.283Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iot1click.CfnPlacementProps")
@software.amazon.jsii.Jsii.Proxy(CfnPlacementProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPlacementProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the project containing the placement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProjectName();

    /**
     * The devices to associate with the placement, as defined by a mapping of zero or more key-value pairs wherein the key is a template name and the value is a device ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedDevices() {
        return null;
    }

    /**
     * The user-defined attributes associated with the placement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return null;
    }

    /**
     * The name of the placement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPlacementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPlacementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPlacementProps> {
        java.lang.String projectName;
        java.lang.Object associatedDevices;
        java.lang.Object attributes;
        java.lang.String placementName;

        /**
         * Sets the value of {@link CfnPlacementProps#getProjectName}
         * @param projectName The name of the project containing the placement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlacementProps#getAssociatedDevices}
         * @param associatedDevices The devices to associate with the placement, as defined by a mapping of zero or more key-value pairs wherein the key is a template name and the value is a device ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedDevices(java.lang.Object associatedDevices) {
            this.associatedDevices = associatedDevices;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlacementProps#getAttributes}
         * @param attributes The user-defined attributes associated with the placement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(java.lang.Object attributes) {
            this.attributes = attributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlacementProps#getPlacementName}
         * @param placementName The name of the placement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementName(java.lang.String placementName) {
            this.placementName = placementName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPlacementProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPlacementProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPlacementProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPlacementProps {
        private final java.lang.String projectName;
        private final java.lang.Object associatedDevices;
        private final java.lang.Object attributes;
        private final java.lang.String placementName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associatedDevices = software.amazon.jsii.Kernel.get(this, "associatedDevices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.placementName = software.amazon.jsii.Kernel.get(this, "placementName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.projectName = java.util.Objects.requireNonNull(builder.projectName, "projectName is required");
            this.associatedDevices = builder.associatedDevices;
            this.attributes = builder.attributes;
            this.placementName = builder.placementName;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final java.lang.Object getAssociatedDevices() {
            return this.associatedDevices;
        }

        @Override
        public final java.lang.Object getAttributes() {
            return this.attributes;
        }

        @Override
        public final java.lang.String getPlacementName() {
            return this.placementName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("projectName", om.valueToTree(this.getProjectName()));
            if (this.getAssociatedDevices() != null) {
                data.set("associatedDevices", om.valueToTree(this.getAssociatedDevices()));
            }
            if (this.getAttributes() != null) {
                data.set("attributes", om.valueToTree(this.getAttributes()));
            }
            if (this.getPlacementName() != null) {
                data.set("placementName", om.valueToTree(this.getPlacementName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iot1click.CfnPlacementProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPlacementProps.Jsii$Proxy that = (CfnPlacementProps.Jsii$Proxy) o;

            if (!projectName.equals(that.projectName)) return false;
            if (this.associatedDevices != null ? !this.associatedDevices.equals(that.associatedDevices) : that.associatedDevices != null) return false;
            if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
            return this.placementName != null ? this.placementName.equals(that.placementName) : that.placementName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.projectName.hashCode();
            result = 31 * result + (this.associatedDevices != null ? this.associatedDevices.hashCode() : 0);
            result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
            result = 31 * result + (this.placementName != null ? this.placementName.hashCode() : 0);
            return result;
        }
    }
}
