package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Properties for a AWS IoT Events action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * ActionConfig actionConfig = ActionConfig.builder()
 *         .configuration(ActionProperty.builder()
 *                 .clearTimer(ClearTimerProperty.builder()
 *                         .timerName("timerName")
 *                         .build())
 *                 .dynamoDb(DynamoDBProperty.builder()
 *                         .hashKeyField("hashKeyField")
 *                         .hashKeyValue("hashKeyValue")
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .hashKeyType("hashKeyType")
 *                         .operation("operation")
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .payloadField("payloadField")
 *                         .rangeKeyField("rangeKeyField")
 *                         .rangeKeyType("rangeKeyType")
 *                         .rangeKeyValue("rangeKeyValue")
 *                         .build())
 *                 .dynamoDBv2(DynamoDBv2Property.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .firehose(FirehoseProperty.builder()
 *                         .deliveryStreamName("deliveryStreamName")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .separator("separator")
 *                         .build())
 *                 .iotEvents(IotEventsProperty.builder()
 *                         .inputName("inputName")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .iotSiteWise(IotSiteWiseProperty.builder()
 *                         .propertyValue(AssetPropertyValueProperty.builder()
 *                                 .value(AssetPropertyVariantProperty.builder()
 *                                         .booleanValue("booleanValue")
 *                                         .doubleValue("doubleValue")
 *                                         .integerValue("integerValue")
 *                                         .stringValue("stringValue")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .quality("quality")
 *                                 .timestamp(AssetPropertyTimestampProperty.builder()
 *                                         .timeInSeconds("timeInSeconds")
 *                                         // the properties below are optional
 *                                         .offsetInNanos("offsetInNanos")
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .assetId("assetId")
 *                         .entryId("entryId")
 *                         .propertyAlias("propertyAlias")
 *                         .propertyId("propertyId")
 *                         .build())
 *                 .iotTopicPublish(IotTopicPublishProperty.builder()
 *                         .mqttTopic("mqttTopic")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .lambda(LambdaProperty.builder()
 *                         .functionArn("functionArn")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .resetTimer(ResetTimerProperty.builder()
 *                         .timerName("timerName")
 *                         .build())
 *                 .setTimer(SetTimerProperty.builder()
 *                         .timerName("timerName")
 *                         // the properties below are optional
 *                         .durationExpression("durationExpression")
 *                         .seconds(123)
 *                         .build())
 *                 .setVariable(SetVariableProperty.builder()
 *                         .value("value")
 *                         .variableName("variableName")
 *                         .build())
 *                 .sns(SnsProperty.builder()
 *                         .targetArn("targetArn")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .sqs(SqsProperty.builder()
 *                         .queueUrl("queueUrl")
 *                         // the properties below are optional
 *                         .payload(PayloadProperty.builder()
 *                                 .contentExpression("contentExpression")
 *                                 .type("type")
 *                                 .build())
 *                         .useBase64(false)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.474Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.ActionConfig")
@software.amazon.jsii.Jsii.Proxy(ActionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ActionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The configuration for this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty getConfiguration();

    /**
     * @return a {@link Builder} of {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ActionConfig> {
        software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty configuration;

        /**
         * Sets the value of {@link ActionConfig#getConfiguration}
         * @param configuration The configuration for this action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder configuration(software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ActionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionConfig {
        private final software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty configuration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
        }

        @Override
        public final software.amazon.awscdk.services.iotevents.CfnDetectorModel.ActionProperty getConfiguration() {
            return this.configuration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("configuration", om.valueToTree(this.getConfiguration()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.ActionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionConfig.Jsii$Proxy that = (ActionConfig.Jsii$Proxy) o;

            return this.configuration.equals(that.configuration);
        }

        @Override
        public final int hashCode() {
            int result = this.configuration.hashCode();
            return result;
        }
    }
}
