package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Expression for events in Detector Model state.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IInput input;
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(actions, List.of(
 *                     new SetVariableAction("MyVariable", Expression.inputAttribute(input, "payload.temperature")))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.655Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.Expression")
public abstract class Expression extends software.amazon.jsii.JsiiObject {

    protected Expression(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Expression(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected Expression() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) Create a expression for the AND operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression and(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "and", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for function `currentInput()`.
     * <p>
     * It is evaluated to true if the specified input message was received.
     * <p>
     * @param input This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression currentInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.IInput input) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "currentInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required") });
    }

    /**
     * (experimental) Create a expression for the Equal operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression eq(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "eq", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression from the given string.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression fromString(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Create a expression for the Greater Than operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression gt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "gt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for the Greater Than Or Equal operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression gte(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "gte", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     * <p>
     * @param input This parameter is required.
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression inputAttribute(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.IInput input, final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "inputAttribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(input, "input is required"), java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Create a expression for the Less Than operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression lt(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "lt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for the Less Than Or Equal operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression lte(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "lte", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for the Not Equal operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression neq(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "neq", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) Create a expression for the OR operator.
     * <p>
     * @param left This parameter is required.
     * @param right This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression or(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression left, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression right) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.iotevents.Expression.class, "or", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class), new Object[] { java.util.Objects.requireNonNull(left, "left is required"), java.util.Objects.requireNonNull(right, "right is required") });
    }

    /**
     * (experimental) This is called to evaluate the expression.
     * <p>
     * @param parentPriority priority of the parent of this expression, used for determining whether or not to add parenthesis around the expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String evaluate(final @org.jetbrains.annotations.Nullable java.lang.Number parentPriority);

    /**
     * (experimental) This is called to evaluate the expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String evaluate();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.iotevents.Expression {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) This is called to evaluate the expression.
         * <p>
         * @param parentPriority priority of the parent of this expression, used for determining whether or not to add parenthesis around the expression.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String evaluate(final @org.jetbrains.annotations.Nullable java.lang.Number parentPriority) {
            return software.amazon.jsii.Kernel.call(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { parentPriority });
        }

        /**
         * (experimental) This is called to evaluate the expression.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String evaluate() {
            return software.amazon.jsii.Kernel.call(this, "evaluate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
