package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Defines a state of a detector.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IInput input;
 * State state = State.Builder.create()
 *         .stateName("MyState")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(actions, List.of(
 *                     new SetVariableAction("MyVariable", Expression.inputAttribute(input, "payload.temperature")))))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.State")
public class State extends software.amazon.jsii.JsiiObject {

    protected State(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected State(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public State(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.StateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add a transition event to the state.
     * <p>
     * The transition event will be triggered if condition is evaluated to <code>true</code>.
     * <p>
     * @param targetState the state that will be transit to when the event triggered. This parameter is required.
     * @param options transition options including the condition that causes the state transition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void transitionTo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.State targetState, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.TransitionOptions options) {
        software.amazon.jsii.Kernel.call(this, "transitionTo", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(targetState, "targetState is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The name of the state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStateName() {
        return software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.iotevents.State}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotevents.State> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.iotevents.StateProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.iotevents.StateProps.Builder();
        }

        /**
         * (experimental) The name of the state.
         * <p>
         * @return {@code this}
         * @param stateName The name of the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * (experimental) Specifies the events on enter.
         * <p>
         * The conditions of the events will be evaluated when entering this state.
         * If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
         * <p>
         * Default: - no events will trigger on entering this state
         * <p>
         * @return {@code this}
         * @param onEnter Specifies the events on enter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onEnter(final java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onEnter) {
            this.props.onEnter(onEnter);
            return this;
        }

        /**
         * (experimental) Specifies the events on exit.
         * <p>
         * The conditions of the events are evaluated when an exiting this state.
         * If the condition evaluates to <code>true</code>, the actions of the event will be executed.
         * <p>
         * Default: - no events will trigger on exiting this state
         * <p>
         * @return {@code this}
         * @param onExit Specifies the events on exit. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onExit(final java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onExit) {
            this.props.onExit(onExit);
            return this;
        }

        /**
         * (experimental) Specifies the events on input.
         * <p>
         * The conditions of the events will be evaluated when any input is received.
         * If the condition of the event evaluates to <code>true</code>, the actions of the event will be executed.
         * <p>
         * Default: - no events will trigger on input in this state
         * <p>
         * @return {@code this}
         * @param onInput Specifies the events on input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onInput(final java.util.List<? extends software.amazon.awscdk.services.iotevents.Event> onInput) {
            this.props.onInput(onInput);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotevents.State}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.iotevents.State build() {
            return new software.amazon.awscdk.services.iotevents.State(
                this.props.build()
            );
        }
    }
}
