package software.amazon.awscdk.services.iotevents;

/**
 * (experimental) Properties for options of state transition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * IFunction func;
 * Input input = Input.Builder.create(this, "MyInput")
 *         .inputName("my_input") // optional
 *         .attributeJsonPaths(List.of("payload.deviceId", "payload.temperature"))
 *         .build();
 * State warmState = State.Builder.create()
 *         .stateName("warm")
 *         .onEnter(List.of(Event.builder()
 *                 .eventName("test-enter-event")
 *                 .condition(Expression.currentInput(input))
 *                 .actions(List.of(new LambdaInvokeAction(func)))
 *                 .build()))
 *         .onInput(List.of(Event.builder() // optional
 *                 .eventName("test-input-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .onExit(List.of(Event.builder() // optional
 *                 .eventName("test-exit-event")
 *                 .actions(List.of(new LambdaInvokeAction(func))).build()))
 *         .build();
 * State coldState = State.Builder.create()
 *         .stateName("cold")
 *         .build();
 * // transit to coldState when temperature is less than 15
 * warmState.transitionTo(coldState, TransitionOptions.builder()
 *         .eventName("to_coldState") // optional property, default by combining the names of the States
 *         .when(Expression.lt(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .executing(List.of(new LambdaInvokeAction(func)))
 *         .build());
 * // transit to warmState when temperature is greater than or equal to 15
 * coldState.transitionTo(warmState, TransitionOptions.builder()
 *         .when(Expression.gte(Expression.inputAttribute(input, "payload.temperature"), Expression.fromString("15")))
 *         .build());
 * DetectorModel.Builder.create(this, "MyDetectorModel")
 *         .detectorModelName("test-detector-model") // optional
 *         .description("test-detector-model-description") // optional property, default is none
 *         .evaluationMethod(EventEvaluation.SERIAL) // optional property, default is iotevents.EventEvaluation.BATCH
 *         .detectorKey("payload.deviceId") // optional property, default is none and single detector instance will be created and all inputs will be routed to it
 *         .initialState(warmState)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.684Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotevents.TransitionOptions")
@software.amazon.jsii.Jsii.Proxy(TransitionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TransitionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The condition that is used to determine to cause the state transition and the actions.
     * <p>
     * When this was evaluated to <code>true</code>, the state transition and the actions are triggered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotevents.Expression getWhen();

    /**
     * (experimental) The name of the event.
     * <p>
     * Default: string combining the names of the States as `${originStateName}_to_${targetStateName}`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventName() {
        return null;
    }

    /**
     * (experimental) The actions to be performed with the transition.
     * <p>
     * Default: - no actions will be performed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iotevents.IAction> getExecuting() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TransitionOptions> {
        software.amazon.awscdk.services.iotevents.Expression when;
        java.lang.String eventName;
        java.util.List<software.amazon.awscdk.services.iotevents.IAction> executing;

        /**
         * Sets the value of {@link TransitionOptions#getWhen}
         * @param when The condition that is used to determine to cause the state transition and the actions. This parameter is required.
         *             When this was evaluated to <code>true</code>, the state transition and the actions are triggered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder when(software.amazon.awscdk.services.iotevents.Expression when) {
            this.when = when;
            return this;
        }

        /**
         * Sets the value of {@link TransitionOptions#getEventName}
         * @param eventName The name of the event.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder eventName(java.lang.String eventName) {
            this.eventName = eventName;
            return this;
        }

        /**
         * Sets the value of {@link TransitionOptions#getExecuting}
         * @param executing The actions to be performed with the transition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder executing(java.util.List<? extends software.amazon.awscdk.services.iotevents.IAction> executing) {
            this.executing = (java.util.List<software.amazon.awscdk.services.iotevents.IAction>)executing;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransitionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TransitionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitionOptions {
        private final software.amazon.awscdk.services.iotevents.Expression when;
        private final java.lang.String eventName;
        private final java.util.List<software.amazon.awscdk.services.iotevents.IAction> executing;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.when = software.amazon.jsii.Kernel.get(this, "when", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.Expression.class));
            this.eventName = software.amazon.jsii.Kernel.get(this, "eventName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executing = software.amazon.jsii.Kernel.get(this, "executing", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iotevents.IAction.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.when = java.util.Objects.requireNonNull(builder.when, "when is required");
            this.eventName = builder.eventName;
            this.executing = (java.util.List<software.amazon.awscdk.services.iotevents.IAction>)builder.executing;
        }

        @Override
        public final software.amazon.awscdk.services.iotevents.Expression getWhen() {
            return this.when;
        }

        @Override
        public final java.lang.String getEventName() {
            return this.eventName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iotevents.IAction> getExecuting() {
            return this.executing;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("when", om.valueToTree(this.getWhen()));
            if (this.getEventName() != null) {
                data.set("eventName", om.valueToTree(this.getEventName()));
            }
            if (this.getExecuting() != null) {
                data.set("executing", om.valueToTree(this.getExecuting()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_iotevents.TransitionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransitionOptions.Jsii$Proxy that = (TransitionOptions.Jsii$Proxy) o;

            if (!when.equals(that.when)) return false;
            if (this.eventName != null ? !this.eventName.equals(that.eventName) : that.eventName != null) return false;
            return this.executing != null ? this.executing.equals(that.executing) : that.executing == null;
        }

        @Override
        public final int hashCode() {
            int result = this.when.hashCode();
            result = 31 * result + (this.eventName != null ? this.eventName.hashCode() : 0);
            result = 31 * result + (this.executing != null ? this.executing.hashCode() : 0);
            return result;
        }
    }
}
