package software.amazon.awscdk.services.iotsitewise;

/**
 * A CloudFormation `AWS::IoTSiteWise::Portal`.
 * <p>
 * Creates a portal, which can contain projects and dashboards. Before you can create a portal, you must enable IAM Identity Center . AWS IoT SiteWise Monitor uses IAM Identity Center to manage user permissions. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Before you can sign in to a new portal, you must add at least one IAM Identity Center user or group to that portal. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins">Adding or removing portal administrators</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * Object alarms;
 * CfnPortal cfnPortal = CfnPortal.Builder.create(this, "MyCfnPortal")
 *         .portalContactEmail("portalContactEmail")
 *         .portalName("portalName")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .alarms(alarms)
 *         .notificationSenderEmail("notificationSenderEmail")
 *         .portalAuthMode("portalAuthMode")
 *         .portalDescription("portalDescription")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:03.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotsitewise.CfnPortal")
public class CfnPortal extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnPortal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPortal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnPortal.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTSiteWise::Portal`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPortal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnPortalProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the portal, which has the following format.
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM Identity Center application generated client ID (used with IAM Identity Center APIs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalClientId() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the created portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalId() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The public URL for the AWS IoT SiteWise Monitor portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPortalStartUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrPortalStartUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pairs that contain metadata for the portal.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal.
     * <p>
     * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <em>AWS IoT SiteWise Application Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAlarms() {
        return software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal.
     * <p>
     * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <em>AWS IoT SiteWise Application Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarms(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "alarms", java.util.Objects.requireNonNull(value, "alarms is required"));
    }

    /**
     * The AWS administrator's contact email address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPortalContactEmail() {
        return software.amazon.jsii.Kernel.get(this, "portalContactEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS administrator's contact email address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortalContactEmail(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "portalContactEmail", java.util.Objects.requireNonNull(value, "portalContactEmail is required"));
    }

    /**
     * A friendly name for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPortalName() {
        return software.amazon.jsii.Kernel.get(this, "portalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortalName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "portalName", java.util.Objects.requireNonNull(value, "portalName is required"));
    }

    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see [Using service roles for AWS IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *AWS IoT SiteWise User Guide* .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see [Using service roles for AWS IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *AWS IoT SiteWise User Guide* .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The email address that sends alarm notifications.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNotificationSenderEmail() {
        return software.amazon.jsii.Kernel.get(this, "notificationSenderEmail", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The email address that sends alarm notifications.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationSenderEmail(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationSenderEmail", value);
    }

    /**
     * The service to use to authenticate users to the portal. Choose from the following options:.
     * <p>
     * <ul>
     * <li><code>SSO</code> – The portal uses AWS IAM Identity Center (successor to AWS Single Sign-On) to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center , you must enable IAM Identity Center . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> . This option is only available in AWS Regions other than the China Regions.</li>
     * <li><code>IAM</code> – The portal uses AWS Identity and Access Management ( IAM ) to authenticate users and manage user permissions.</li>
     * </ul>
     * <p>
     * You can't change this value after you create a portal.
     * <p>
     * Default: <code>SSO</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPortalAuthMode() {
        return software.amazon.jsii.Kernel.get(this, "portalAuthMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The service to use to authenticate users to the portal. Choose from the following options:.
     * <p>
     * <ul>
     * <li><code>SSO</code> – The portal uses AWS IAM Identity Center (successor to AWS Single Sign-On) to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center , you must enable IAM Identity Center . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> . This option is only available in AWS Regions other than the China Regions.</li>
     * <li><code>IAM</code> – The portal uses AWS Identity and Access Management ( IAM ) to authenticate users and manage user permissions.</li>
     * </ul>
     * <p>
     * You can't change this value after you create a portal.
     * <p>
     * Default: <code>SSO</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortalAuthMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "portalAuthMode", value);
    }

    /**
     * A description for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPortalDescription() {
        return software.amazon.jsii.Kernel.get(this, "portalDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description for the portal.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortalDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "portalDescription", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * AlarmsProperty alarmsProperty = AlarmsProperty.builder()
     *         .alarmRoleArn("alarmRoleArn")
     *         .notificationLambdaArn("notificationLambdaArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_iotsitewise.CfnPortal.AlarmsProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPortal.AlarmsProperty.AlarmRoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAlarmRoleArn() {
            return null;
        }

        /**
         * `CfnPortal.AlarmsProperty.NotificationLambdaArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNotificationLambdaArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmsProperty> {
            java.lang.String alarmRoleArn;
            java.lang.String notificationLambdaArn;

            /**
             * Sets the value of {@link AlarmsProperty#getAlarmRoleArn}
             * @param alarmRoleArn `CfnPortal.AlarmsProperty.AlarmRoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmRoleArn(java.lang.String alarmRoleArn) {
                this.alarmRoleArn = alarmRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link AlarmsProperty#getNotificationLambdaArn}
             * @param notificationLambdaArn `CfnPortal.AlarmsProperty.NotificationLambdaArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationLambdaArn(java.lang.String notificationLambdaArn) {
                this.notificationLambdaArn = notificationLambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmsProperty {
            private final java.lang.String alarmRoleArn;
            private final java.lang.String notificationLambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmRoleArn = software.amazon.jsii.Kernel.get(this, "alarmRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationLambdaArn = software.amazon.jsii.Kernel.get(this, "notificationLambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmRoleArn = builder.alarmRoleArn;
                this.notificationLambdaArn = builder.notificationLambdaArn;
            }

            @Override
            public final java.lang.String getAlarmRoleArn() {
                return this.alarmRoleArn;
            }

            @Override
            public final java.lang.String getNotificationLambdaArn() {
                return this.notificationLambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarmRoleArn() != null) {
                    data.set("alarmRoleArn", om.valueToTree(this.getAlarmRoleArn()));
                }
                if (this.getNotificationLambdaArn() != null) {
                    data.set("notificationLambdaArn", om.valueToTree(this.getNotificationLambdaArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("monocdk.aws_iotsitewise.CfnPortal.AlarmsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmsProperty.Jsii$Proxy that = (AlarmsProperty.Jsii$Proxy) o;

                if (this.alarmRoleArn != null ? !this.alarmRoleArn.equals(that.alarmRoleArn) : that.alarmRoleArn != null) return false;
                return this.notificationLambdaArn != null ? this.notificationLambdaArn.equals(that.notificationLambdaArn) : that.notificationLambdaArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmRoleArn != null ? this.alarmRoleArn.hashCode() : 0;
                result = 31 * result + (this.notificationLambdaArn != null ? this.notificationLambdaArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnPortal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnPortal> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnPortalProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnPortalProps.Builder();
        }

        /**
         * The AWS administrator's contact email address.
         * <p>
         * @return {@code this}
         * @param portalContactEmail The AWS administrator's contact email address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalContactEmail(final java.lang.String portalContactEmail) {
            this.props.portalContactEmail(portalContactEmail);
            return this;
        }

        /**
         * A friendly name for the portal.
         * <p>
         * @return {@code this}
         * @param portalName A friendly name for the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalName(final java.lang.String portalName) {
            this.props.portalName(portalName);
            return this;
        }

        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see [Using service roles for AWS IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *AWS IoT SiteWise User Guide* .
         * <p>
         * @return {@code this}
         * @param roleArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of a service role that allows the portal's users to access your AWS IoT SiteWise resources on your behalf. For more information, see [Using service roles for AWS IoT SiteWise Monitor](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html) in the *AWS IoT SiteWise User Guide* . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal.
         * <p>
         * You can use the alarm to monitor an asset property and get notified when the asset property value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in the <em>AWS IoT SiteWise Application Guide</em> .
         * <p>
         * @return {@code this}
         * @param alarms Contains the configuration information of an alarm created in an AWS IoT SiteWise Monitor portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarms(final java.lang.Object alarms) {
            this.props.alarms(alarms);
            return this;
        }

        /**
         * The email address that sends alarm notifications.
         * <p>
         * <blockquote>
         * <p>
         * If you use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS IoT Events managed Lambda function</a> to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the sender email address in Amazon SES</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param notificationSenderEmail The email address that sends alarm notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationSenderEmail(final java.lang.String notificationSenderEmail) {
            this.props.notificationSenderEmail(notificationSenderEmail);
            return this;
        }

        /**
         * The service to use to authenticate users to the portal. Choose from the following options:.
         * <p>
         * <ul>
         * <li><code>SSO</code> – The portal uses AWS IAM Identity Center (successor to AWS Single Sign-On) to authenticate users and manage user permissions. Before you can create a portal that uses IAM Identity Center , you must enable IAM Identity Center . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso">Enabling IAM Identity Center</a> in the <em>AWS IoT SiteWise User Guide</em> . This option is only available in AWS Regions other than the China Regions.</li>
         * <li><code>IAM</code> – The portal uses AWS Identity and Access Management ( IAM ) to authenticate users and manage user permissions.</li>
         * </ul>
         * <p>
         * You can't change this value after you create a portal.
         * <p>
         * Default: <code>SSO</code>
         * <p>
         * @return {@code this}
         * @param portalAuthMode The service to use to authenticate users to the portal. Choose from the following options:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalAuthMode(final java.lang.String portalAuthMode) {
            this.props.portalAuthMode(portalAuthMode);
            return this;
        }

        /**
         * A description for the portal.
         * <p>
         * @return {@code this}
         * @param portalDescription A description for the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portalDescription(final java.lang.String portalDescription) {
            this.props.portalDescription(portalDescription);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the portal.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pairs that contain metadata for the portal. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnPortal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnPortal build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnPortal(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
