package software.amazon.awscdk.services.ivs;

/**
 * (experimental) Properties for creating a new Playback Key Pair.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PlaybackKeyPair keyPair = PlaybackKeyPair.Builder.create(this, "PlaybackKeyPair")
 *         .publicKeyMaterial(myPublicKeyPemString)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.037Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_ivs.PlaybackKeyPairProps")
@software.amazon.jsii.Jsii.Proxy(PlaybackKeyPairProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PlaybackKeyPairProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The public portion of a customer-generated key pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicKeyMaterial();

    /**
     * (experimental) An arbitrary string (a nickname) assigned to a playback key pair that helps the customer identify that resource.
     * <p>
     * The value does not need to be unique.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PlaybackKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PlaybackKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PlaybackKeyPairProps> {
        java.lang.String publicKeyMaterial;
        java.lang.String name;

        /**
         * Sets the value of {@link PlaybackKeyPairProps#getPublicKeyMaterial}
         * @param publicKeyMaterial The public portion of a customer-generated key pair. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder publicKeyMaterial(java.lang.String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        /**
         * Sets the value of {@link PlaybackKeyPairProps#getName}
         * @param name An arbitrary string (a nickname) assigned to a playback key pair that helps the customer identify that resource.
         *             The value does not need to be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PlaybackKeyPairProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PlaybackKeyPairProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PlaybackKeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlaybackKeyPairProps {
        private final java.lang.String publicKeyMaterial;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publicKeyMaterial = software.amazon.jsii.Kernel.get(this, "publicKeyMaterial", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publicKeyMaterial = java.util.Objects.requireNonNull(builder.publicKeyMaterial, "publicKeyMaterial is required");
            this.name = builder.name;
        }

        @Override
        public final java.lang.String getPublicKeyMaterial() {
            return this.publicKeyMaterial;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publicKeyMaterial", om.valueToTree(this.getPublicKeyMaterial()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_ivs.PlaybackKeyPairProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PlaybackKeyPairProps.Jsii$Proxy that = (PlaybackKeyPairProps.Jsii$Proxy) o;

            if (!publicKeyMaterial.equals(that.publicKeyMaterial)) return false;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        @Override
        public final int hashCode() {
            int result = this.publicKeyMaterial.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}
