package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) An interface expressing the public properties on both an imported and CDK-created Flink application.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.458Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.IApplication")
@software.amazon.jsii.Jsii.Proxy(IApplication.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IApplication extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource, software.amazon.awscdk.services.iam.IGrantable {

    /**
     * (experimental) The application ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn();

    /**
     * (experimental) The name of the Flink application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * (experimental) The application IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * (experimental) Convenience method for adding a policy statement to the application role.
     * <p>
     * @param policyStatement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Boolean addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement policyStatement);

    /**
     * (experimental) Return a CloudWatch metric associated with this Flink application.
     * <p>
     * @param metricName The name of the metric. This parameter is required.
     * @param props Customization properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Return a CloudWatch metric associated with this Flink application.
     * <p>
     * @param metricName The name of the metric. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName);

    /**
     * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond();

    /**
     * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
     * <p>
     * Can be NaN, if the value could not be
     * calculated.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
     * <p>
     * Can be NaN, if the value could not be
     * calculated.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond();

    /**
     * (experimental) The overall percentage of CPU utilization across task managers.
     * <p>
     * For
     * example, if there are five task managers, Kinesis Data Analytics publishes
     * five samples of this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The overall percentage of CPU utilization across task managers.
     * <p>
     * For
     * example, if there are five task managers, Kinesis Data Analytics publishes
     * five samples of this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization();

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark();

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The last watermark this application/operator/task/thread has received.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark();

    /**
     * (experimental) The time elapsed during an outage for failing/recovering jobs.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time elapsed during an outage for failing/recovering jobs.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime();

    /**
     * (experimental) The total number of times this job has fully restarted since it was submitted.
     * <p>
     * This metric does not measure fine-grained restarts.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of times this job has fully restarted since it was submitted.
     * <p>
     * This metric does not measure fine-grained restarts.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts();

    /**
     * (experimental) Overall heap memory utilization across task managers.
     * <p>
     * For example, if there
     * are five task managers, Kinesis Data Analytics publishes five samples of
     * this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Overall heap memory utilization across task managers.
     * <p>
     * For example, if there
     * are five task managers, Kinesis Data Analytics publishes five samples of
     * this metric per reporting interval.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization();

    /**
     * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
     * <p>
     * Idle time excludes back pressured time, so if the task
     * is back pressured it is not idle.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
     * <p>
     * Idle time excludes back pressured time, so if the task
     * is back pressured it is not idle.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond();

    /**
     * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
     * <p>
     * The average number of KPUs used each hour
     * determines the billing for your application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
     * <p>
     * The average number of KPUs used each hour
     * determines the billing for your application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus();

    /**
     * (experimental) The time it took to complete the last checkpoint.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time it took to complete the last checkpoint.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration();

    /**
     * (experimental) The total size of the last checkpoint.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total size of the last checkpoint.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: maximum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize();

    /**
     * (experimental) The total amount of managed memory.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total amount of managed memory.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal();

    /**
     * (experimental) The amount of managed memory currently used.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The amount of managed memory currently used.
     * <p>
     * Units: Bytes
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed();

    /**
     * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
     * <p>
     * Units: Percentage
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization();

    /**
     * (experimental) The number of times checkpointing has failed.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of times checkpointing has failed.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints();

    /**
     * (experimental) The number of records this operator or task has dropped due to arriving late.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The number of records this operator or task has dropped due to arriving late.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped();

    /**
     * (experimental) The total number of records this application, operator, or task has received.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of records this application, operator, or task has received.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn();

    /**
     * (experimental) The total number of records this application, operator or task has received per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of records this application, operator or task has received per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond();

    /**
     * (experimental) The total number of records this application, operator or task has emitted.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of records this application, operator or task has emitted.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut();

    /**
     * (experimental) The total number of records this application, operator or task has emitted per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of records this application, operator or task has emitted per second.
     * <p>
     * Units: Count/Second
     * <p>
     * Reporting Level: Application, Operator, Task, Parallelism
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond();

    /**
     * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount();

    /**
     * (experimental) The total time spent performing old garbage collection operations.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total time spent performing old garbage collection operations.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime();

    /**
     * (experimental) The total number of live threads used by the application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The total number of live threads used by the application.
     * <p>
     * Units: Count
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount();

    /**
     * (experimental) The time that the job has been running without interruption.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sample count over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props);

    /**
     * (experimental) The time that the job has been running without interruption.
     * <p>
     * Units: Milliseconds
     * <p>
     * Reporting Level: Application
     * <p>
     * Default: sample count over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.analytics.flink.IApplication.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) The application ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn() {
            return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of the Flink application.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
            return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The application IAM role.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
            return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Convenience method for adding a policy statement to the application role.
         * <p>
         * @param policyStatement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement policyStatement) {
            return software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(policyStatement, "policyStatement is required") });
        }

        /**
         * (experimental) Return a CloudWatch metric associated with this Flink application.
         * <p>
         * @param metricName The name of the metric. This parameter is required.
         * @param props Customization properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) Return a CloudWatch metric associated with this Flink application.
         * <p>
         * @param metricName The name of the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricBackPressuredTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond() {
            return software.amazon.jsii.Kernel.call(this, "metricBackPressuredTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
         * <p>
         * Can be NaN, if the value could not be
         * calculated.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricBusyTimePerMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
         * <p>
         * Can be NaN, if the value could not be
         * calculated.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond() {
            return software.amazon.jsii.Kernel.call(this, "metricBusyTimePerMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The overall percentage of CPU utilization across task managers.
         * <p>
         * For
         * example, if there are five task managers, Kinesis Data Analytics publishes
         * five samples of this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The overall percentage of CPU utilization across task managers.
         * <p>
         * For
         * example, if there are five task managers, Kinesis Data Analytics publishes
         * five samples of this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentInputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark() {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentInputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentOutputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark() {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentOutputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The time elapsed during an outage for failing/recovering jobs.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDowntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time elapsed during an outage for failing/recovering jobs.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime() {
            return software.amazon.jsii.Kernel.call(this, "metricDowntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of times this job has fully restarted since it was submitted.
         * <p>
         * This metric does not measure fine-grained restarts.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFullRestarts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of times this job has fully restarted since it was submitted.
         * <p>
         * This metric does not measure fine-grained restarts.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts() {
            return software.amazon.jsii.Kernel.call(this, "metricFullRestarts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Overall heap memory utilization across task managers.
         * <p>
         * For example, if there
         * are five task managers, Kinesis Data Analytics publishes five samples of
         * this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricHeapMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Overall heap memory utilization across task managers.
         * <p>
         * For example, if there
         * are five task managers, Kinesis Data Analytics publishes five samples of
         * this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricHeapMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
         * <p>
         * Idle time excludes back pressured time, so if the task
         * is back pressured it is not idle.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIdleTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
         * <p>
         * Idle time excludes back pressured time, so if the task
         * is back pressured it is not idle.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond() {
            return software.amazon.jsii.Kernel.call(this, "metricIdleTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
         * <p>
         * The average number of KPUs used each hour
         * determines the billing for your application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
         * <p>
         * The average number of KPUs used each hour
         * determines the billing for your application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus() {
            return software.amazon.jsii.Kernel.call(this, "metricKpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The time it took to complete the last checkpoint.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time it took to complete the last checkpoint.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration() {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total size of the last checkpoint.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total size of the last checkpoint.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize() {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total amount of managed memory.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryTotal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total amount of managed memory.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal() {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryTotal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The amount of managed memory currently used.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The amount of managed memory currently used.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed() {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization() {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of times checkpointing has failed.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfFailedCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of times checkpointing has failed.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints() {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfFailedCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The number of records this operator or task has dropped due to arriving late.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumLateRecordsDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of records this operator or task has dropped due to arriving late.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped() {
            return software.amazon.jsii.Kernel.call(this, "metricNumLateRecordsDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of records this application, operator, or task has received.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsIn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator, or task has received.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn() {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsIn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of records this application, operator or task has received per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsInPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has received per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond() {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsInPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut() {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOutPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond() {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOutPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount() {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total time spent performing old garbage collection operations.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total time spent performing old garbage collection operations.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime() {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The total number of live threads used by the application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricThreadsCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of live threads used by the application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount() {
            return software.amazon.jsii.Kernel.call(this, "metricThreadsCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }

        /**
         * (experimental) The time that the job has been running without interruption.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sample count over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time that the job has been running without interruption.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sample count over 5 minutes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime() {
            return software.amazon.jsii.Kernel.call(this, "metricUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
        }
    }

    /**
     * Internal default implementation for {@link IApplication}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IApplication, software.amazon.awscdk.core.IResource.Jsii$Default, software.amazon.awscdk.services.iam.IGrantable.Jsii$Default {

        /**
         * (experimental) The construct tree node for this construct.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ConstructNode.class));
        }

        /**
         * (experimental) The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.ResourceEnvironment.class));
        }

        /**
         * (experimental) The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Stack.class));
        }

        /**
         * (experimental) The principal to grant permissions to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
            return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
        }

        /**
         * (experimental) The application ARN.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getApplicationArn() {
            return software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The name of the Flink application.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.NotNull java.lang.String getApplicationName() {
            return software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The application IAM role.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
            return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * (experimental) Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * (experimental) Convenience method for adding a policy statement to the application role.
         * <p>
         * @param policyStatement This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull java.lang.Boolean addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement policyStatement) {
            return software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(policyStatement, "policyStatement is required") });
        }

        /**
         * (experimental) Return a CloudWatch metric associated with this Flink application.
         * <p>
         * @param metricName The name of the metric. This parameter is required.
         * @param props Customization properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is back pressured per second.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBackPressuredTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricBackPressuredTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is busy (neither idle nor back pressured) per second.
         * <p>
         * Can be NaN, if the value could not be
         * calculated.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricBusyTimePerMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricBusyTimePerMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The overall percentage of CPU utilization across task managers.
         * <p>
         * For
         * example, if there are five task managers, Kinesis Data Analytics publishes
         * five samples of this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentInputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentInputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The last watermark this application/operator/task/thread has received.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCurrentOutputWatermark(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricCurrentOutputWatermark", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time elapsed during an outage for failing/recovering jobs.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDowntime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricDowntime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of times this job has fully restarted since it was submitted.
         * <p>
         * This metric does not measure fine-grained restarts.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFullRestarts(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricFullRestarts", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Overall heap memory utilization across task managers.
         * <p>
         * For example, if there
         * are five task managers, Kinesis Data Analytics publishes five samples of
         * this metric per reporting interval.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricHeapMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricHeapMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time (in milliseconds) this task or operator is idle (has no data to process) per second.
         * <p>
         * Idle time excludes back pressured time, so if the task
         * is back pressured it is not idle.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIdleTimeMsPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricIdleTimeMsPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of Kinesis Processing Units that are used to run your stream processing application.
         * <p>
         * The average number of KPUs used each hour
         * determines the billing for your application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricKpus(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricKpus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time it took to complete the last checkpoint.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total size of the last checkpoint.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: maximum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLastCheckpointSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricLastCheckpointSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total amount of managed memory.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryTotal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryTotal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The amount of managed memory currently used.
         * <p>
         * Units: Bytes
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUsed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUsed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) Derived from managedMemoryUsed/managedMemoryTotal.
         * <p>
         * Units: Percentage
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricManagedMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricManagedMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of times checkpointing has failed.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumberOfFailedCheckpoints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumberOfFailedCheckpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The number of records this operator or task has dropped due to arriving late.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumLateRecordsDropped(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumLateRecordsDropped", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator, or task has received.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsIn(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsIn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has received per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsInPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsInPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOut(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOut", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of records this application, operator or task has emitted per second.
         * <p>
         * Units: Count/Second
         * <p>
         * Reporting Level: Application, Operator, Task, Parallelism
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricNumRecordsOutPerSecond(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricNumRecordsOutPerSecond", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of old garbage collection operations that have occurred across all task managers.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total time spent performing old garbage collection operations.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sum over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricOldGenerationGCTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricOldGenerationGCTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The total number of live threads used by the application.
         * <p>
         * Units: Count
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: average over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThreadsCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricThreadsCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }

        /**
         * (experimental) The time that the job has been running without interruption.
         * <p>
         * Units: Milliseconds
         * <p>
         * Reporting Level: Application
         * <p>
         * Default: sample count over 5 minutes
         * <p>
         * @param props
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricUptime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
            return software.amazon.jsii.Kernel.call(this, "metricUptime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
        }
    }
}
