package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) Available log levels for Flink applications.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Application flinkApp = Application.Builder.create(this, "Application")
 *         .code(ApplicationCode.fromBucket(bucket, "my-app.jar"))
 *         .runtime(Runtime.FLINK_1_13)
 *         .checkpointingEnabled(true) // default is true
 *         .checkpointInterval(Duration.seconds(30)) // default is 1 minute
 *         .minPauseBetweenCheckpoints(Duration.seconds(10)) // default is 5 seconds
 *         .logLevel(LogLevel.ERROR) // default is INFO
 *         .metricsLevel(MetricsLevel.PARALLELISM) // default is APPLICATION
 *         .autoScalingEnabled(false) // default is true
 *         .parallelism(32) // default is 1
 *         .parallelismPerKpu(2) // default is 1
 *         .snapshotsEnabled(false) // default is true
 *         .logGroup(new LogGroup(this, "LogGroup"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.482Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.LogLevel")
public enum LogLevel {
    /**
     * (experimental) Debug level logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DEBUG,
    /**
     * (experimental) Info level logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INFO,
    /**
     * (experimental) Warn level logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WARN,
    /**
     * (experimental) Error level logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ERROR,
}
