package software.amazon.awscdk.services.kinesis.analytics.flink;

/**
 * (experimental) Granularity of metrics sent to CloudWatch.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Application flinkApp = Application.Builder.create(this, "Application")
 *         .code(ApplicationCode.fromBucket(bucket, "my-app.jar"))
 *         .runtime(Runtime.FLINK_1_13)
 *         .checkpointingEnabled(true) // default is true
 *         .checkpointInterval(Duration.seconds(30)) // default is 1 minute
 *         .minPauseBetweenCheckpoints(Duration.seconds(10)) // default is 5 seconds
 *         .logLevel(LogLevel.ERROR) // default is INFO
 *         .metricsLevel(MetricsLevel.PARALLELISM) // default is APPLICATION
 *         .autoScalingEnabled(false) // default is true
 *         .parallelism(32) // default is 1
 *         .parallelismPerKpu(2) // default is 1
 *         .snapshotsEnabled(false) // default is true
 *         .logGroup(new LogGroup(this, "LogGroup"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.483Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisanalytics_flink.MetricsLevel")
public enum MetricsLevel {
    /**
     * (experimental) Application sends the least metrics to CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    APPLICATION,
    /**
     * (experimental) Task includes task-level metrics sent to CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TASK,
    /**
     * (experimental) Operator includes task-level and operator-level metrics sent to CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    OPERATOR,
    /**
     * (experimental) Send all metrics including metrics per task thread.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    PARALLELISM,
}
