package software.amazon.awscdk.services.kinesisfirehose.destinations;

/**
 * (experimental) Options for S3 record backup of a delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.lambda.nodejs.*;
 * import software.amazon.awscdk.services.logs.*;
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-cdk-firehose-delivery-stream-s3-all-properties");
 * Bucket bucket = Bucket.Builder.create(stack, "Bucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * Bucket backupBucket = Bucket.Builder.create(stack, "BackupBucket")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .autoDeleteObjects(true)
 *         .build();
 * LogGroup logGroup = LogGroup.Builder.create(stack, "LogGroup")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * NodejsFunction dataProcessorFunction = NodejsFunction.Builder.create(stack, "DataProcessorFunction")
 *         .entry(join(__dirname, "lambda-data-processor.js"))
 *         .timeout(Duration.minutes(1))
 *         .build();
 * LambdaFunctionProcessor processor = LambdaFunctionProcessor.Builder.create(dataProcessorFunction)
 *         .bufferInterval(Duration.seconds(60))
 *         .bufferSize(Size.mebibytes(1))
 *         .retries(1)
 *         .build();
 * Key key = Key.Builder.create(stack, "Key")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * Key backupKey = Key.Builder.create(stack, "BackupKey")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * DeliveryStream.Builder.create(stack, "Delivery Stream")
 *         .destinations(List.of(S3Bucket.Builder.create(bucket)
 *                 .logging(true)
 *                 .logGroup(logGroup)
 *                 .processor(processor)
 *                 .compression(Compression.GZIP)
 *                 .dataOutputPrefix("regularPrefix")
 *                 .errorOutputPrefix("errorPrefix")
 *                 .bufferingInterval(Duration.seconds(60))
 *                 .bufferingSize(Size.mebibytes(1))
 *                 .encryptionKey(key)
 *                 .s3Backup(DestinationS3BackupProps.builder()
 *                         .mode(BackupMode.ALL)
 *                         .bucket(backupBucket)
 *                         .compression(Compression.ZIP)
 *                         .dataOutputPrefix("backupPrefix")
 *                         .errorOutputPrefix("backupErrorPrefix")
 *                         .bufferingInterval(Duration.seconds(60))
 *                         .bufferingSize(Size.mebibytes(1))
 *                         .encryptionKey(backupKey)
 *                         .build())
 *                 .build()))
 *         .build();
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.758Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_kinesisfirehose_destinations.BackupMode")
public enum BackupMode {
    /**
     * (experimental) All records are backed up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ALL,
    /**
     * (experimental) Only records that failed to deliver or transform are backed up.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FAILED,
}
