package software.amazon.awscdk.services.lambda;

/**
 * (experimental) Architectures supported by AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_16_X)
 *         .handler("index.handler")
 *         .architecture(Architecture.ARM_64)
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         .insightsVersion(LambdaInsightsVersion.VERSION_1_0_119_0)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:04.984Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda.Architecture")
public class Architecture extends software.amazon.jsii.JsiiObject {

    protected Architecture(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Architecture(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ARM_64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Architecture.class, "ARM_64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
        X86_64 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Architecture.class, "X86_64", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
    }

    /**
     * (experimental) Used to specify a custom architecture name.
     * <p>
     * Use this if the architecture name is not yet supported by the CDK.
     * <p>
     * @param name the architecture name as recognized by AWS Lambda. This parameter is required.
     * @param dockerPlatform the platform to use for this architecture when building with Docker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture custom(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable java.lang.String dockerPlatform) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Architecture.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), dockerPlatform });
    }

    /**
     * (experimental) Used to specify a custom architecture name.
     * <p>
     * Use this if the architecture name is not yet supported by the CDK.
     * <p>
     * @param name the architecture name as recognized by AWS Lambda. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture custom(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Architecture.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) 64 bit architecture with the ARM instruction set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.lambda.Architecture ARM_64;

    /**
     * (experimental) 64 bit architecture with x86 instruction set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.lambda.Architecture X86_64;

    /**
     * (experimental) The platform to use for this architecture when building with Docker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDockerPlatform() {
        return software.amazon.jsii.Kernel.get(this, "dockerPlatform", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the architecture as recognized by the AWS Lambda service APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
