package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnLayerVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnLayerVersionProps cfnLayerVersionProps = CfnLayerVersionProps.builder()
 *         .content(ContentProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 // the properties below are optional
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build())
 *         // the properties below are optional
 *         .compatibleArchitectures(List.of("compatibleArchitectures"))
 *         .compatibleRuntimes(List.of("compatibleRuntimes"))
 *         .description("description")
 *         .layerName("layerName")
 *         .licenseInfo("licenseInfo")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:05.092Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.aws_lambda.CfnLayerVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnLayerVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLayerVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The function layer archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContent();

    /**
     * A list of compatible [instruction set architectures](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCompatibleArchitectures() {
        return null;
    }

    /**
     * A list of compatible [function runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) . Used for filtering with [ListLayers](https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayers.html) and [ListLayerVersions](https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayerVersions.html) .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCompatibleRuntimes() {
        return null;
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name or Amazon Resource Name (ARN) of the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLayerName() {
        return null;
    }

    /**
     * The layer's software license. It can be any of the following:.
     * <p>
     * <ul>
     * <li>An <a href="https://docs.aws.amazon.com/https://spdx.org/licenses/">SPDX license identifier</a> . For example, <code>MIT</code> .</li>
     * <li>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code> .</li>
     * <li>The full text of the license.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLicenseInfo() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLayerVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLayerVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLayerVersionProps> {
        java.lang.Object content;
        java.util.List<java.lang.String> compatibleArchitectures;
        java.util.List<java.lang.String> compatibleRuntimes;
        java.lang.String description;
        java.lang.String layerName;
        java.lang.String licenseInfo;

        /**
         * Sets the value of {@link CfnLayerVersionProps#getContent}
         * @param content The function layer archive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.services.lambda.CfnLayerVersion.ContentProperty content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getContent}
         * @param content The function layer archive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(software.amazon.awscdk.core.IResolvable content) {
            this.content = content;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getCompatibleArchitectures}
         * @param compatibleArchitectures A list of compatible [instruction set architectures](https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibleArchitectures(java.util.List<java.lang.String> compatibleArchitectures) {
            this.compatibleArchitectures = compatibleArchitectures;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getCompatibleRuntimes}
         * @param compatibleRuntimes A list of compatible [function runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html) . Used for filtering with [ListLayers](https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayers.html) and [ListLayerVersions](https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayerVersions.html) .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibleRuntimes(java.util.List<java.lang.String> compatibleRuntimes) {
            this.compatibleRuntimes = compatibleRuntimes;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getDescription}
         * @param description The description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getLayerName}
         * @param layerName The name or Amazon Resource Name (ARN) of the layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerName(java.lang.String layerName) {
            this.layerName = layerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionProps#getLicenseInfo}
         * @param licenseInfo The layer's software license. It can be any of the following:.
         *                    <ul>
         *                    <li>An <a href="https://docs.aws.amazon.com/https://spdx.org/licenses/">SPDX license identifier</a> . For example, <code>MIT</code> .</li>
         *                    <li>The URL of a license hosted on the internet. For example, <code>https://opensource.org/licenses/MIT</code> .</li>
         *                    <li>The full text of the license.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseInfo(java.lang.String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLayerVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLayerVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLayerVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLayerVersionProps {
        private final java.lang.Object content;
        private final java.util.List<java.lang.String> compatibleArchitectures;
        private final java.util.List<java.lang.String> compatibleRuntimes;
        private final java.lang.String description;
        private final java.lang.String layerName;
        private final java.lang.String licenseInfo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.compatibleArchitectures = software.amazon.jsii.Kernel.get(this, "compatibleArchitectures", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.compatibleRuntimes = software.amazon.jsii.Kernel.get(this, "compatibleRuntimes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.layerName = software.amazon.jsii.Kernel.get(this, "layerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.licenseInfo = software.amazon.jsii.Kernel.get(this, "licenseInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
            this.compatibleArchitectures = builder.compatibleArchitectures;
            this.compatibleRuntimes = builder.compatibleRuntimes;
            this.description = builder.description;
            this.layerName = builder.layerName;
            this.licenseInfo = builder.licenseInfo;
        }

        @Override
        public final java.lang.Object getContent() {
            return this.content;
        }

        @Override
        public final java.util.List<java.lang.String> getCompatibleArchitectures() {
            return this.compatibleArchitectures;
        }

        @Override
        public final java.util.List<java.lang.String> getCompatibleRuntimes() {
            return this.compatibleRuntimes;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLayerName() {
            return this.layerName;
        }

        @Override
        public final java.lang.String getLicenseInfo() {
            return this.licenseInfo;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("content", om.valueToTree(this.getContent()));
            if (this.getCompatibleArchitectures() != null) {
                data.set("compatibleArchitectures", om.valueToTree(this.getCompatibleArchitectures()));
            }
            if (this.getCompatibleRuntimes() != null) {
                data.set("compatibleRuntimes", om.valueToTree(this.getCompatibleRuntimes()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLayerName() != null) {
                data.set("layerName", om.valueToTree(this.getLayerName()));
            }
            if (this.getLicenseInfo() != null) {
                data.set("licenseInfo", om.valueToTree(this.getLicenseInfo()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("monocdk.aws_lambda.CfnLayerVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLayerVersionProps.Jsii$Proxy that = (CfnLayerVersionProps.Jsii$Proxy) o;

            if (!content.equals(that.content)) return false;
            if (this.compatibleArchitectures != null ? !this.compatibleArchitectures.equals(that.compatibleArchitectures) : that.compatibleArchitectures != null) return false;
            if (this.compatibleRuntimes != null ? !this.compatibleRuntimes.equals(that.compatibleRuntimes) : that.compatibleRuntimes != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.layerName != null ? !this.layerName.equals(that.layerName) : that.layerName != null) return false;
            return this.licenseInfo != null ? this.licenseInfo.equals(that.licenseInfo) : that.licenseInfo == null;
        }

        @Override
        public final int hashCode() {
            int result = this.content.hashCode();
            result = 31 * result + (this.compatibleArchitectures != null ? this.compatibleArchitectures.hashCode() : 0);
            result = 31 * result + (this.compatibleRuntimes != null ? this.compatibleRuntimes.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.layerName != null ? this.layerName.hashCode() : 0);
            result = 31 * result + (this.licenseInfo != null ? this.licenseInfo.hashCode() : 0);
            return result;
        }
    }
}
